/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import org.junit.jupiter.api.Assertions;
import reactor.core.publisher.Mono;

public final class ServiceVersionValidationPolicy
implements HttpPipelinePolicy {
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private final String expectedServiceVersion;

    public ServiceVersionValidationPolicy(String expectedServiceVersion) {
        this.expectedServiceVersion = expectedServiceVersion;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        String actualServiceVersion = httpPipelineCallContext.getHttpRequest().getHeaders().getValue(X_MS_VERSION);
        Assertions.assertEquals((Object)this.expectedServiceVersion, (Object)actualServiceVersion);
        return httpPipelineNextPolicy.process();
    }

    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

