/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.client.traits.HttpTrait;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientProvider;
import com.azure.core.http.okhttp.OkHttpAsyncClientProvider;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.vertx.VertxAsyncHttpClientProvider;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.utils.TestResourceNamer;
import com.azure.core.test.utils.TestUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.storage.common.test.shared.ServiceVersionValidationPolicy;
import com.azure.storage.common.test.shared.TestEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import org.junit.jupiter.api.Assertions;

public final class StorageCommonTestUtils {
    public static final TestEnvironment ENVIRONMENT;
    private static final HttpClient NETTY_HTTP_CLIENT;
    private static final HttpClient OK_HTTP_CLIENT;
    private static final HttpClient VERTX_HTTP_CLIENT;
    private static final HttpClient JDK_HTTP_HTTP_CLIENT;

    private static HttpClient createJdkHttpClient() throws ReflectiveOperationException {
        Class<?> clazz = Class.forName("com.azure.core.http.jdk.httpclient.JdkHttpClientProvider");
        return (HttpClient)clazz.getDeclaredMethod("createInstance", new Class[0]).invoke(clazz.newInstance(), new Object[0]);
    }

    public static String getCrc32(String input) {
        CRC32 crc32 = new CRC32();
        crc32.update(input.getBytes(StandardCharsets.UTF_8));
        return String.format(Locale.US, "%08X", crc32.getValue()).toLowerCase();
    }

    public static HttpClient getHttpClient(Supplier<HttpClient> playbackClientSupplier) {
        if (ENVIRONMENT.getTestMode() != TestMode.PLAYBACK) {
            switch (ENVIRONMENT.getHttpClientType()) {
                case NETTY: {
                    return NETTY_HTTP_CLIENT;
                }
                case OK_HTTP: {
                    return OK_HTTP_CLIENT;
                }
                case VERTX: {
                    return VERTX_HTTP_CLIENT;
                }
                case JDK_HTTP: {
                    return JDK_HTTP_HTTP_CLIENT;
                }
            }
            throw new IllegalArgumentException("Unknown http client type: " + (Object)((Object)ENVIRONMENT.getHttpClientType()));
        }
        return playbackClientSupplier.get();
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) {
        return StorageCommonTestUtils.convertInputStreamToByteArray(inputStream, 4096);
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream, int expectedSize) {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(expectedSize);
        try {
            int b;
            while ((b = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, b);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareFiles(File file1, File file2, long offset, long count) throws IOException {
        int defaultBufferSize = 131072;
        FileInputStream stream1 = new FileInputStream(file1);
        stream1.skip(offset);
        FileInputStream stream2 = new FileInputStream(file2);
        try {
            long pos;
            int expectedReadCount;
            int bufferSize = (int)Math.min((long)defaultBufferSize, count);
            for (pos = 0L; pos < count; pos += (long)expectedReadCount) {
                expectedReadCount = (int)Math.min((long)bufferSize, count - pos);
                byte[] buffer1 = new byte[expectedReadCount];
                byte[] buffer2 = new byte[expectedReadCount];
                int readCount1 = stream1.read(buffer1);
                int readCount2 = stream2.read(buffer2);
                TestUtils.assertArraysEqual((byte[])buffer1, (byte[])buffer2);
                Assertions.assertEquals((int)readCount1, (int)readCount2);
            }
            int verificationRead = stream2.read();
            boolean bl = pos == count && verificationRead == -1;
            return bl;
        }
        finally {
            stream1.close();
            stream2.close();
        }
    }

    public static <T extends HttpTrait<T>, E extends Enum<E>> T instrument(T builder, HttpLogOptions logOptions, InterceptorManager interceptorManager) {
        builder.httpClient(StorageCommonTestUtils.getHttpClient(interceptorManager));
        if (interceptorManager.isRecordMode()) {
            builder.addPolicy(interceptorManager.getRecordPolicy());
        }
        if (ENVIRONMENT.getServiceVersion() != null) {
            try {
                Method serviceVersionMethod = Arrays.stream(builder.getClass().getDeclaredMethods()).filter(method -> "serviceVersion".equals(method.getName()) && method.getParameterCount() == 1 && ServiceVersion.class.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElseThrow(() -> new RuntimeException("Unable to find serviceVersion method for builder: " + builder.getClass()));
                Class<?> serviceVersionClass = serviceVersionMethod.getParameterTypes()[0];
                ServiceVersion serviceVersion = (ServiceVersion)Enum.valueOf(serviceVersionClass, ENVIRONMENT.getServiceVersion());
                serviceVersionMethod.invoke(builder, serviceVersion);
                builder.addPolicy((HttpPipelinePolicy)new ServiceVersionValidationPolicy(serviceVersion.getVersion()));
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return (T)builder.httpLogOptions(logOptions);
    }

    public static HttpClient getHttpClient(InterceptorManager interceptorManager) {
        return StorageCommonTestUtils.getHttpClient(() -> ((InterceptorManager)interceptorManager).getPlaybackClient());
    }

    public static byte[] getRandomByteArray(int size, TestResourceNamer testResourceNamer) {
        long seed = UUID.fromString(testResourceNamer.randomUuid()).getMostSignificantBits() & Long.MAX_VALUE;
        Random rand = new Random(seed);
        byte[] data = new byte[size];
        rand.nextBytes(data);
        return data;
    }

    public static ByteBuffer getRandomData(int size, TestResourceNamer testResourceNamer) {
        return ByteBuffer.wrap(StorageCommonTestUtils.getRandomByteArray(size, testResourceNamer));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getRandomFile(int size, TestResourceNamer testResourceNamer) throws IOException {
        try {
            File file = File.createTempFile(CoreUtils.randomUuid().toString(), ".txt");
            file.deleteOnExit();
            if (size > 0x100000) {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    byte[] data = StorageCommonTestUtils.getRandomByteArray(0x100000, testResourceNamer);
                    int mbChunks = size / 0x100000;
                    int remaining = size % 0x100000;
                    for (int i = 0; i < mbChunks; ++i) {
                        fos.write(data);
                    }
                    if (remaining <= 0) return file;
                    fos.write(data, 0, remaining);
                    return file;
                }
            } else {
                Files.write(file.toPath(), StorageCommonTestUtils.getRandomByteArray(size, testResourceNamer), new OpenOption[0]);
            }
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        HttpClient jdkHttpHttpClient;
        ENVIRONMENT = TestEnvironment.getInstance();
        NETTY_HTTP_CLIENT = new NettyAsyncHttpClientProvider().createInstance();
        OK_HTTP_CLIENT = new OkHttpAsyncClientProvider().createInstance();
        VERTX_HTTP_CLIENT = new VertxAsyncHttpClientProvider().createInstance();
        try {
            jdkHttpHttpClient = StorageCommonTestUtils.createJdkHttpClient();
        }
        catch (LinkageError | ReflectiveOperationException e) {
            jdkHttpHttpClient = null;
        }
        JDK_HTTP_HTTP_CLIENT = jdkHttpHttpClient;
    }
}

