/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.test.TestMode;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.PlaybackOnly;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class PlaybackOnlyExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotationUtils.findAnnotation((Optional)context.getElement(), PlaybackOnly.class).ifPresent(PlaybackOnlyExtension::validateExpiryTime);
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        return testMode != TestMode.PLAYBACK ? ConditionEvaluationResult.disabled((String)("Test ignored in " + testMode + " mode")) : ConditionEvaluationResult.enabled((String)("Test enabled in " + testMode + " mode"));
    }

    private static void validateExpiryTime(PlaybackOnly annotation) {
        String expiryStr = annotation.expiryTime();
        if ("".equals(expiryStr)) {
            return;
        }
        OffsetDateTime expiry = LocalDate.parse(expiryStr, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atTime(0, 0).atZone(ZoneId.of(ZoneId.SHORT_IDS.get("PST"))).toOffsetDateTime();
        OffsetDateTime now = OffsetDateTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("PST")));
        if (now.isAfter(expiry)) {
            throw new RuntimeException("PlaybackOnly has expired. Test must be re-enabled");
        }
    }
}

