/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.util.ServiceVersion;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.RequiredServiceVersion;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class RequiredServiceVersionExtension
implements ExecutionCondition {
    private static final Map<Class<? extends Enum<? extends ServiceVersion>>, ServiceVersion[]> ALL_SERVICE_VERSIONS = new ConcurrentHashMap<Class<? extends Enum<? extends ServiceVersion>>, ServiceVersion[]>();
    private static final Map<Class<? extends Enum<? extends ServiceVersion>>, ServiceVersion> LATEST_SERVICE_VERSIONS = new ConcurrentHashMap<Class<? extends Enum<? extends ServiceVersion>>, ServiceVersion>();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        RequiredServiceVersion requiredServiceVersion = AnnotationUtils.findAnnotation((Optional)context.getElement(), RequiredServiceVersion.class).orElse(null);
        if (requiredServiceVersion == null) {
            return ConditionEvaluationResult.enabled((String)"No service version required");
        }
        if (RequiredServiceVersionExtension.shouldSkip(requiredServiceVersion.clazz(), requiredServiceVersion.min())) {
            return ConditionEvaluationResult.disabled((String)("Test ignored to run with " + requiredServiceVersion.min() + " service version"));
        }
        return ConditionEvaluationResult.enabled((String)("Test enabled to run with " + requiredServiceVersion.min() + " service version"));
    }

    private static boolean shouldSkip(Class<? extends Enum<? extends ServiceVersion>> targetEnumClass, String minServiceVersion) {
        ServiceVersion[] serviceVersions = RequiredServiceVersionExtension.getServiceVersions(targetEnumClass);
        String environmentServiceVersion = TestEnvironment.getInstance().getServiceVersion();
        if (environmentServiceVersion == null) {
            environmentServiceVersion = RequiredServiceVersionExtension.getLatestServiceVersion(targetEnumClass).toString();
        }
        int minOrdinal = RequiredServiceVersionExtension.getOrdinal(serviceVersions, minServiceVersion);
        int environmentOrdinal = RequiredServiceVersionExtension.getOrdinal(serviceVersions, environmentServiceVersion);
        return environmentOrdinal < minOrdinal;
    }

    private static ServiceVersion[] getServiceVersions(Class<? extends Enum<? extends ServiceVersion>> clazz) {
        return ALL_SERVICE_VERSIONS.computeIfAbsent(clazz, c -> (ServiceVersion[])clazz.getEnumConstants());
    }

    private static ServiceVersion getLatestServiceVersion(Class<? extends Enum<? extends ServiceVersion>> clazz) {
        return LATEST_SERVICE_VERSIONS.computeIfAbsent(clazz, c -> {
            try {
                return (ServiceVersion)clazz.getDeclaredMethod("getLatest", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static int getOrdinal(ServiceVersion[] serviceVersions, String target) {
        for (int i = 0; i < serviceVersions.length; ++i) {
            if (!Objects.equals(String.valueOf(serviceVersions[i]), target)) continue;
            return i;
        }
        return -1;
    }
}

