/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.storage.common.test.shared.policy.MockDownloadHttpResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MockRetryRangeResponsePolicy
implements HttpPipelinePolicy {
    private static final HttpHeaderName X_MS_RANGE = HttpHeaderName.fromString((String)"x-ms-range");
    private final String rangeMatch;

    public MockRetryRangeResponsePolicy(String rangeMatch) {
        this.rangeMatch = rangeMatch;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> {
            if (!Objects.equals(response.getRequest().getHeaders().getValue(X_MS_RANGE), this.rangeMatch)) {
                return Mono.error((Throwable)new IllegalArgumentException("The range header was not set correctly on retry."));
            }
            return Mono.just((Object)((Object)new MockDownloadHttpResponse((HttpResponse)response, 206, (Flux<ByteBuffer>)Flux.error((Throwable)new IOException()))));
        });
    }
}

