/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import reactor.core.publisher.Mono;

public final class PerCallVersionPolicy
implements HttpPipelinePolicy {
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private final String version;

    public PerCallVersionPolicy(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        context.getHttpRequest().setHeader(X_MS_VERSION, this.version);
        return next.process();
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        context.getHttpRequest().setHeader(X_MS_VERSION, this.version);
        return next.processSync();
    }

    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

