/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.policy.RetryPolicyType;
import java.util.concurrent.TimeUnit;

public final class RequestRetryOptions {
    private final ClientLogger logger = new ClientLogger(RequestRetryOptions.class);
    private final int maxTries;
    private final int tryTimeout;
    private final long retryDelayInMs;
    private final long maxRetryDelayInMs;
    private final RetryPolicyType retryPolicyType;
    private final String secondaryHost;

    public RequestRetryOptions() {
        this(RetryPolicyType.EXPONENTIAL, null, null, null, null, null);
    }

    public RequestRetryOptions(RetryPolicyType retryPolicyType, Integer maxTries, Integer tryTimeout, Long retryDelayInMs, Long maxRetryDelayInMs, String secondaryHost) {
        RetryPolicyType retryPolicyType2 = this.retryPolicyType = retryPolicyType == null ? RetryPolicyType.EXPONENTIAL : retryPolicyType;
        if (maxTries != null) {
            StorageImplUtils.assertInBounds("maxRetries", maxTries.intValue(), 1L, Integer.MAX_VALUE);
            this.maxTries = maxTries;
        } else {
            this.maxTries = 4;
        }
        if (tryTimeout != null) {
            StorageImplUtils.assertInBounds("tryTimeout", tryTimeout.intValue(), 1L, Integer.MAX_VALUE);
            this.tryTimeout = tryTimeout;
        } else {
            this.tryTimeout = Integer.MAX_VALUE;
        }
        if (retryDelayInMs == null && maxRetryDelayInMs != null || retryDelayInMs != null && maxRetryDelayInMs == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Both retryDelay and maxRetryDelay must be null or neither can be null"));
        }
        if (retryDelayInMs != null) {
            StorageImplUtils.assertInBounds("maxRetryDelayInMs", maxRetryDelayInMs, 1L, Long.MAX_VALUE);
            StorageImplUtils.assertInBounds("retryDelayInMs", retryDelayInMs, 1L, maxRetryDelayInMs);
            this.maxRetryDelayInMs = maxRetryDelayInMs;
            this.retryDelayInMs = retryDelayInMs;
        } else {
            switch (this.retryPolicyType) {
                case EXPONENTIAL: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(4L);
                    break;
                }
                case FIXED: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(30L);
                    break;
                }
                default: {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid 'RetryPolicyType'."));
                }
            }
            this.maxRetryDelayInMs = TimeUnit.SECONDS.toMillis(120L);
        }
        this.secondaryHost = secondaryHost;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public int getTryTimeout() {
        return this.tryTimeout;
    }

    public String getSecondaryHost() {
        return this.secondaryHost;
    }

    public long getRetryDelayInMs() {
        return this.retryDelayInMs;
    }

    public long getMaxRetryDelayInMs() {
        return this.maxRetryDelayInMs;
    }

    long calculateDelayInMs(int tryCount) {
        long delay;
        switch (this.retryPolicyType) {
            case EXPONENTIAL: {
                delay = (this.powOfTwo(tryCount - 1) - 1L) * this.retryDelayInMs;
                break;
            }
            case FIXED: {
                delay = tryCount > 1 ? this.retryDelayInMs : 0L;
                break;
            }
            default: {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid retry policy type."));
            }
        }
        return Math.min(delay, this.maxRetryDelayInMs);
    }

    private long powOfTwo(int exponent) {
        long result = 1L;
        for (int i = 0; i < exponent; ++i) {
            result *= 2L;
        }
        return result;
    }
}

