/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.BufferAggregator;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import reactor.core.publisher.Flux;

public final class UploadBufferPool {
    private final ClientLogger logger = new ClientLogger(UploadBufferPool.class);
    private final BlockingQueue<BufferAggregator> buffers;
    private final int maxBuffs;
    private int numBuffs;
    private final long buffSize;
    private BufferAggregator currentBuf;

    public UploadBufferPool(int numBuffs, long buffSize, long maxBuffSize) {
        StorageImplUtils.assertInBounds("numBuffs", numBuffs, 2L, Integer.MAX_VALUE);
        this.maxBuffs = numBuffs;
        this.buffers = new LinkedBlockingQueue<BufferAggregator>(numBuffs);
        StorageImplUtils.assertInBounds("buffSize", buffSize, 1L, maxBuffSize);
        this.buffSize = buffSize;
        this.buffers.add(new BufferAggregator(this.buffSize));
        this.buffers.add(new BufferAggregator(this.buffSize));
        this.numBuffs = 2;
    }

    public Flux<BufferAggregator> write(ByteBuffer buf) {
        Flux result;
        if (this.currentBuf == null) {
            this.currentBuf = this.getBuffer();
        }
        if (this.currentBuf.remainingCapacity() >= (long)buf.remaining()) {
            this.currentBuf.append(buf);
            if (this.currentBuf.remainingCapacity() == 0L) {
                result = Flux.just((Object)this.currentBuf);
                this.currentBuf = null;
            } else {
                result = Flux.empty();
            }
        } else {
            ByteBuffer duplicate = buf.duplicate();
            int newLimit = buf.position() + (int)this.currentBuf.remainingCapacity();
            duplicate.limit(newLimit);
            this.currentBuf.append(duplicate);
            buf.position(newLimit);
            result = Flux.just((Object)this.currentBuf);
            this.currentBuf = this.getBuffer();
            this.currentBuf.append(buf);
        }
        return result;
    }

    private BufferAggregator getBuffer() {
        BufferAggregator result;
        if (this.buffers.isEmpty() && this.numBuffs < this.maxBuffs) {
            result = new BufferAggregator(this.buffSize);
            ++this.numBuffs;
        } else {
            try {
                result = this.buffers.take();
            }
            catch (InterruptedException e) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("BufferedUpload thread interrupted. Thread:" + Thread.currentThread().getId()));
            }
        }
        return result;
    }

    public Flux<BufferAggregator> flush() {
        if (this.currentBuf != null) {
            BufferAggregator last = this.currentBuf;
            this.currentBuf = null;
            return Flux.just((Object)last);
        }
        return Flux.empty();
    }

    public void returnBuffer(BufferAggregator b) {
        b.reset();
        try {
            this.buffers.put(new BufferAggregator(this.buffSize));
        }
        catch (InterruptedException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("UploadFromStream thread interrupted."));
        }
    }
}

