// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

/** Parameter group. */
@JacksonXmlRootElement(localName = "SourceModifiedAccessConditions")
@Fluent
public final class SourceModifiedAccessConditions {
    /*
     * Specify an ETag value to operate only on blobs with a matching value.
     */
    @JsonProperty(value = "sourceIfMatch")
    private String sourceIfMatch;

    /*
     * Specify an ETag value to operate only on blobs without a matching value.
     */
    @JsonProperty(value = "sourceIfNoneMatch")
    private String sourceIfNoneMatch;

    /*
     * Specify this header value to operate only on a blob if it has been modified since the specified date/time.
     */
    @JsonProperty(value = "sourceIfModifiedSince")
    private DateTimeRfc1123 sourceIfModifiedSince;

    /*
     * Specify this header value to operate only on a blob if it has not been modified since the specified date/time.
     */
    @JsonProperty(value = "sourceIfUnmodifiedSince")
    private DateTimeRfc1123 sourceIfUnmodifiedSince;

    /** Creates an instance of SourceModifiedAccessConditions class. */
    public SourceModifiedAccessConditions() {}

    /**
     * Get the sourceIfMatch property: Specify an ETag value to operate only on blobs with a matching value.
     *
     * @return the sourceIfMatch value.
     */
    public String getSourceIfMatch() {
        return this.sourceIfMatch;
    }

    /**
     * Set the sourceIfMatch property: Specify an ETag value to operate only on blobs with a matching value.
     *
     * @param sourceIfMatch the sourceIfMatch value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfMatch(String sourceIfMatch) {
        this.sourceIfMatch = sourceIfMatch;
        return this;
    }

    /**
     * Get the sourceIfNoneMatch property: Specify an ETag value to operate only on blobs without a matching value.
     *
     * @return the sourceIfNoneMatch value.
     */
    public String getSourceIfNoneMatch() {
        return this.sourceIfNoneMatch;
    }

    /**
     * Set the sourceIfNoneMatch property: Specify an ETag value to operate only on blobs without a matching value.
     *
     * @param sourceIfNoneMatch the sourceIfNoneMatch value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfNoneMatch(String sourceIfNoneMatch) {
        this.sourceIfNoneMatch = sourceIfNoneMatch;
        return this;
    }

    /**
     * Get the sourceIfModifiedSince property: Specify this header value to operate only on a blob if it has been
     * modified since the specified date/time.
     *
     * @return the sourceIfModifiedSince value.
     */
    public OffsetDateTime getSourceIfModifiedSince() {
        if (this.sourceIfModifiedSince == null) {
            return null;
        }
        return this.sourceIfModifiedSince.getDateTime();
    }

    /**
     * Set the sourceIfModifiedSince property: Specify this header value to operate only on a blob if it has been
     * modified since the specified date/time.
     *
     * @param sourceIfModifiedSince the sourceIfModifiedSince value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfModifiedSince(OffsetDateTime sourceIfModifiedSince) {
        if (sourceIfModifiedSince == null) {
            this.sourceIfModifiedSince = null;
        } else {
            this.sourceIfModifiedSince = new DateTimeRfc1123(sourceIfModifiedSince);
        }
        return this;
    }

    /**
     * Get the sourceIfUnmodifiedSince property: Specify this header value to operate only on a blob if it has not been
     * modified since the specified date/time.
     *
     * @return the sourceIfUnmodifiedSince value.
     */
    public OffsetDateTime getSourceIfUnmodifiedSince() {
        if (this.sourceIfUnmodifiedSince == null) {
            return null;
        }
        return this.sourceIfUnmodifiedSince.getDateTime();
    }

    /**
     * Set the sourceIfUnmodifiedSince property: Specify this header value to operate only on a blob if it has not been
     * modified since the specified date/time.
     *
     * @param sourceIfUnmodifiedSince the sourceIfUnmodifiedSince value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfUnmodifiedSince(OffsetDateTime sourceIfUnmodifiedSince) {
        if (sourceIfUnmodifiedSince == null) {
            this.sourceIfUnmodifiedSince = null;
        } else {
            this.sourceIfUnmodifiedSince = new DateTimeRfc1123(sourceIfUnmodifiedSince);
        }
        return this;
    }
}
