// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Defines headers for Create operation.
 */
@Fluent
public final class FileSystemCreateHeaders {
    /*
     * A UTC date/time value generated by the service that indicates the time
     * at which the response was initiated.
     */
    @JsonProperty(value = "Date")
    private DateTimeRfc1123 dateProperty;

    /*
     * An HTTP entity tag associated with the FileSystem.
     */
    @JsonProperty(value = "ETag")
    private String eTag;

    /*
     * The data and time the filesystem was last modified.  Operations on files
     * and directories do not affect the last modified time.
     */
    @JsonProperty(value = "Last-Modified")
    private DateTimeRfc1123 lastModified;

    /*
     * A server-generated UUID recorded in the analytics logs for
     * troubleshooting and correlation.
     */
    @JsonProperty(value = "x-ms-request-id")
    private String clientRequestId;

    /*
     * The version of the REST protocol used to process the request.
     */
    @JsonProperty(value = "x-ms-version")
    private String version;

    /*
     * A bool string indicates whether the namespace feature is enabled. If
     * "true", the namespace is enabled for the filesystem.
     */
    @JsonProperty(value = "x-ms-namespace-enabled")
    private String namespaceEnabled;

    /*
     * The errorCode property.
     */
    @JsonProperty(value = "x-ms-error-code")
    private String errorCode;

    /**
     * Get the dateProperty property: A UTC date/time value generated by the
     * service that indicates the time at which the response was initiated.
     *
     * @return the dateProperty value.
     */
    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    /**
     * Set the dateProperty property: A UTC date/time value generated by the
     * service that indicates the time at which the response was initiated.
     *
     * @param dateProperty the dateProperty value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setDateProperty(OffsetDateTime dateProperty) {
        if (dateProperty == null) {
            this.dateProperty = null;
        } else {
            this.dateProperty = new DateTimeRfc1123(dateProperty);
        }
        return this;
    }

    /**
     * Get the eTag property: An HTTP entity tag associated with the
     * FileSystem.
     *
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: An HTTP entity tag associated with the
     * FileSystem.
     *
     * @param eTag the eTag value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the lastModified property: The data and time the filesystem was last
     * modified.  Operations on files and directories do not affect the last
     * modified time.
     *
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The data and time the filesystem was last
     * modified.  Operations on files and directories do not affect the last
     * modified time.
     *
     * @param lastModified the lastModified value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the clientRequestId property: A server-generated UUID recorded in
     * the analytics logs for troubleshooting and correlation.
     *
     * @return the clientRequestId value.
     */
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: A server-generated UUID recorded in
     * the analytics logs for troubleshooting and correlation.
     *
     * @param clientRequestId the clientRequestId value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the version property: The version of the REST protocol used to
     * process the request.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of the REST protocol used to
     * process the request.
     *
     * @param version the version value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the namespaceEnabled property: A bool string indicates whether the
     * namespace feature is enabled. If "true", the namespace is enabled for
     * the filesystem.
     *
     * @return the namespaceEnabled value.
     */
    public String getNamespaceEnabled() {
        return this.namespaceEnabled;
    }

    /**
     * Set the namespaceEnabled property: A bool string indicates whether the
     * namespace feature is enabled. If "true", the namespace is enabled for
     * the filesystem.
     *
     * @param namespaceEnabled the namespaceEnabled value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setNamespaceEnabled(String namespaceEnabled) {
        this.namespaceEnabled = namespaceEnabled;
        return this;
    }

    /**
     * Get the errorCode property: The errorCode property.
     *
     * @return the errorCode value.
     */
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode property: The errorCode property.
     *
     * @param errorCode the errorCode value to set.
     * @return the FileSystemCreateHeaders object itself.
     */
    public FileSystemCreateHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}
