/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.credentials.SasTokenCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeFileSystemClient.class, DataLakeFileSystemAsyncClient.class})
public class DataLakeFileSystemClientBuilder {
    private final ClientLogger logger = new ClientLogger(DataLakeFileSystemClientBuilder.class);
    private final BlobContainerClientBuilder blobContainerClientBuilder;
    private String endpoint;
    private String accountName;
    private String fileSystemName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private SasTokenCredential sasTokenCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> additionalPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private DataLakeServiceVersion version;

    public DataLakeFileSystemClientBuilder() {
        this.logOptions = DataLakeFileSystemClientBuilder.getDefaultHttpLogOptions();
        this.blobContainerClientBuilder = new BlobContainerClientBuilder();
    }

    public DataLakeFileSystemClient buildClient() {
        return new DataLakeFileSystemClient(this.buildAsyncClient(), this.blobContainerClientBuilder.buildClient());
    }

    public DataLakeFileSystemAsyncClient buildAsyncClient() {
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty((CharSequence)this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.sasTokenCredential, this.endpoint, this.retryOptions, this.logOptions, this.httpClient, this.additionalPolicies, this.configuration, this.logger);
        return new DataLakeFileSystemAsyncClient(pipeline, String.format("%s/%s", this.endpoint, dataLakeFileSystemName), serviceVersion, this.accountName, dataLakeFileSystemName, this.blobContainerClientBuilder.buildAsyncClient());
    }

    public DataLakeFileSystemClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobContainerClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse((URL)url);
            this.accountName = parts.getAccountName();
            this.fileSystemName = parts.getBlobContainerName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage Datalake endpoint url is malformed."));
        }
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(TokenCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder sasToken(String sasToken) {
        this.blobContainerClientBuilder.sasToken(sasToken);
        this.sasTokenCredential = new SasTokenCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder setAnonymousAccess() {
        this.blobContainerClientBuilder.setAnonymousAccess();
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder fileSystemName(String fileSystemName) {
        this.blobContainerClientBuilder.containerName(fileSystemName);
        this.fileSystemName = fileSystemName;
        return this;
    }

    public DataLakeFileSystemClientBuilder httpClient(HttpClient httpClient) {
        this.blobContainerClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public DataLakeFileSystemClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobContainerClientBuilder.addPolicy(pipelinePolicy);
        this.additionalPolicies.add(Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null"));
        return this;
    }

    public DataLakeFileSystemClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobContainerClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder configuration(Configuration configuration) {
        this.blobContainerClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakeFileSystemClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobContainerClientBuilder.retryOptions(retryOptions);
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobContainerClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DataLakeFileSystemClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobContainerClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }
}

