/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientBuilder;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientImpl;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathCreateHeaders;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesHeaders;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlHeaders;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathAccessControl;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class DataLakePathAsyncClient {
    private final ClientLogger logger = new ClientLogger(DataLakePathAsyncClient.class);
    final DataLakeStorageClientImpl dataLakeStorage;
    private final String accountName;
    private final String fileSystemName;
    final String pathName;
    private final DataLakeServiceVersion serviceVersion;
    final PathResourceType pathResourceType;
    final BlockBlobAsyncClient blockBlobAsyncClient;

    DataLakePathAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String pathName, PathResourceType pathResourceType, BlockBlobAsyncClient blockBlobAsyncClient) {
        this.dataLakeStorage = new DataLakeStorageClientBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).build();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.pathName = Utility.urlEncode((String)Utility.urlDecode((String)pathName));
        this.pathResourceType = pathResourceType;
        this.blockBlobAsyncClient = blockBlobAsyncClient;
    }

    static String buildMetadataString(Map<String, String> metadata) {
        StringBuilder sb = new StringBuilder();
        if (!CoreUtils.isNullOrEmpty(metadata)) {
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                if (Objects.isNull(entry.getKey()) || entry.getKey().isEmpty()) {
                    throw new IllegalArgumentException("The key for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                if (Objects.isNull(entry.getValue()) || entry.getValue().isEmpty()) {
                    throw new IllegalArgumentException("The value for one of the metadata key-value pairs is null, empty, or whitespace.");
                }
                sb.append(entry.getKey()).append('=').append(new String(Base64.getEncoder().encode(entry.getValue().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    String getPathUrl() {
        return this.dataLakeStorage.getUrl();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    String getObjectPath() {
        return this.pathName == null ? null : Utility.urlDecode((String)this.pathName);
    }

    String getObjectName() {
        String[] pathParts = this.getObjectPath().split("/");
        return pathParts[pathParts.length - 1];
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeStorage.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public Mono<PathInfo> create() {
        try {
            return this.create(false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PathInfo> create(boolean overwrite) {
        try {
            DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
            if (!overwrite) {
                requestConditions.setIfNoneMatch("*");
            }
            return this.createWithResponse(null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PathInfo>> createWithResponse(String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(permissions, umask, this.pathResourceType, headers, metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> createWithResponse(String permissions, String umask, PathResourceType resourceType, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.paths().createWithRestResponseAsync(resourceType, null, null, null, null, DataLakePathAsyncClient.buildMetadataString(metadata), permissions, umask, null, null, headers, lac, mac, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathCreateHeaders)response.getDeserializedHeaders()).getETag(), ((PathCreateHeaders)response.getDeserializedHeaders()).getLastModified())));
    }

    Mono<Response<Void>> deleteWithResponse(Boolean recursive, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.paths().deleteWithRestResponseAsync(recursive, null, null, null, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> setHttpHeaders(PathHttpHeaders headers) {
        try {
            return this.setHttpHeadersWithResponse(headers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setHttpHeadersWithResponse(PathHttpHeaders headers, DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.setHttpHeadersWithResponse(Transforms.toBlobHttpHeaders(headers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PathProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PathProperties>> getPropertiesWithResponse(DataLakeRequestConditions requestConditions) {
        try {
            return this.blockBlobAsyncClient.getPropertiesWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toPathProperties((BlobProperties)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Boolean> exists() {
        try {
            return this.existsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return this.blockBlobAsyncClient.existsWithResponse().onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PathInfo> setAccessControlList(List<PathAccessControlEntry> accessControlList, String group, String owner) {
        try {
            return this.setAccessControlListWithResponse(accessControlList, group, owner, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PathInfo>> setAccessControlListWithResponse(List<PathAccessControlEntry> accessControlList, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(accessControlList, null, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<PathInfo> setPermissions(PathPermissions permissions, String group, String owner) {
        try {
            return this.setPermissionsWithResponse(permissions, group, owner, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PathInfo>> setPermissionsWithResponse(PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setAccessControlWithResponse(null, permissions, group, owner, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathInfo>> setAccessControlWithResponse(List<PathAccessControlEntry> accessControlList, PathPermissions permissions, String group, String owner, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        String permissionsString = permissions == null ? null : permissions.toString();
        String accessControlListString = accessControlList == null ? null : PathAccessControlEntry.serializeList(accessControlList);
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.paths().setAccessControlWithRestResponseAsync(null, owner, group, permissionsString, accessControlListString, null, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathInfo(((PathSetAccessControlHeaders)response.getDeserializedHeaders()).getETag(), ((PathSetAccessControlHeaders)response.getDeserializedHeaders()).getLastModified())));
    }

    public Mono<PathAccessControl> getAccessControl() {
        try {
            return this.getAccessControlWithResponse(false, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getAccessControlWithResponse(userPrincipalNameReturned, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PathAccessControl>> getAccessControlWithResponse(boolean userPrincipalNameReturned, DataLakeRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new DataLakeRequestConditions() : requestConditions;
        LeaseAccessConditions lac = new LeaseAccessConditions().setLeaseId(requestConditions.getLeaseId());
        ModifiedAccessConditions mac = new ModifiedAccessConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince());
        context = context == null ? Context.NONE : context;
        return this.dataLakeStorage.paths().getPropertiesWithRestResponseAsync(PathGetPropertiesAction.GET_ACCESS_CONTROL, userPrincipalNameReturned, null, null, lac, mac, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)new PathAccessControl(PathAccessControlEntry.parseList(((PathGetPropertiesHeaders)response.getDeserializedHeaders()).getAcl()), PathPermissions.parseSymbolic(((PathGetPropertiesHeaders)response.getDeserializedHeaders()).getPermissions()), ((PathGetPropertiesHeaders)response.getDeserializedHeaders()).getGroup(), ((PathGetPropertiesHeaders)response.getDeserializedHeaders()).getOwner())));
    }

    Mono<Response<DataLakePathAsyncClient>> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Context context) {
        destinationRequestConditions = destinationRequestConditions == null ? new DataLakeRequestConditions() : destinationRequestConditions;
        sourceRequestConditions = sourceRequestConditions == null ? new DataLakeRequestConditions() : sourceRequestConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().setSourceIfModifiedSince(sourceRequestConditions.getIfModifiedSince()).setSourceIfUnmodifiedSince(sourceRequestConditions.getIfUnmodifiedSince()).setSourceIfMatch(sourceRequestConditions.getIfMatch()).setSourceIfNoneMatch(sourceRequestConditions.getIfNoneMatch());
        LeaseAccessConditions destLac = new LeaseAccessConditions().setLeaseId(destinationRequestConditions.getLeaseId());
        ModifiedAccessConditions destMac = new ModifiedAccessConditions().setIfMatch(destinationRequestConditions.getIfMatch()).setIfNoneMatch(destinationRequestConditions.getIfNoneMatch()).setIfModifiedSince(destinationRequestConditions.getIfModifiedSince()).setIfUnmodifiedSince(destinationRequestConditions.getIfUnmodifiedSince());
        DataLakePathAsyncClient dataLakePathAsyncClient = this.getPathAsyncClient(destinationFileSystem, destinationPath);
        String renameSource = "/" + this.fileSystemName + "/" + this.pathName;
        return dataLakePathAsyncClient.dataLakeStorage.paths().createWithRestResponseAsync(null, null, PathRenameMode.LEGACY, renameSource, sourceRequestConditions.getLeaseId(), null, null, null, null, null, null, destLac, destMac, sourceConditions, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, (Object)dataLakePathAsyncClient));
    }

    DataLakePathAsyncClient getPathAsyncClient(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)destinationPath)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'destinationPath' can not be set to null"));
        }
        String newDfsEndpoint = BlobUrlParts.parse((String)this.getPathUrl()).setBlobName(destinationPath).setContainerName(destinationFileSystem).toUrl().toString();
        return new DataLakePathAsyncClient(this.getHttpPipeline(), newDfsEndpoint, this.serviceVersion, this.accountName, destinationFileSystem, destinationPath, this.pathResourceType, this.prepareBuilderReplacePath(destinationFileSystem, destinationPath).buildBlockBlobAsyncClient());
    }

    SpecializedBlobClientBuilder prepareBuilderReplacePath(String destinationFileSystem, String destinationPath) {
        if (destinationFileSystem == null) {
            destinationFileSystem = this.getFileSystemName();
        }
        String newBlobEndpoint = BlobUrlParts.parse((String)DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs")).setBlobName(destinationPath).setContainerName(destinationFileSystem).toUrl().toString();
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(newBlobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion()));
    }

    BlockBlobAsyncClient getBlockBlobAsyncClient() {
        return this.blockBlobAsyncClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.blockBlobAsyncClient.generateUserDelegationSas(Transforms.toBlobSasValues(dataLakeServiceSasSignatureValues), Transforms.toBlobUserDelegationKey(userDelegationKey));
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.blockBlobAsyncClient.generateSas(Transforms.toBlobSasValues(dataLakeServiceSasSignatureValues));
    }
}

