// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Path model.
 */
@Fluent
public final class Path implements JsonSerializable<Path> {

    /*
     * The name property.
     */
    private String name;

    /*
     * The isDirectory property.
     */
    private Boolean isDirectory;

    /*
     * The lastModified property.
     */
    private String lastModified;

    /*
     * The contentLength property.
     */
    private Long contentLength;

    /*
     * The owner property.
     */
    private String owner;

    /*
     * The group property.
     */
    private String group;

    /*
     * The permissions property.
     */
    private String permissions;

    /*
     * The name of the encryption scope under which the blob is encrypted.
     */
    private String encryptionScope;

    /*
     * The creationTime property.
     */
    private String creationTime;

    /*
     * The expiryTime property.
     */
    private String expiryTime;

    /*
     * The EncryptionContext property.
     */
    private String encryptionContext;

    /*
     * The etag property.
     */
    private String eTag;

    /**
     * Creates an instance of Path class.
     */
    public Path() {
    }

    /**
     * Get the name property: The name property.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     *
     * @param name the name value to set.
     * @return the Path object itself.
     */
    public Path setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the isDirectory property: The isDirectory property.
     *
     * @return the isDirectory value.
     */
    public Boolean isDirectory() {
        return this.isDirectory;
    }

    /**
     * Set the isDirectory property: The isDirectory property.
     *
     * @param isDirectory the isDirectory value to set.
     * @return the Path object itself.
     */
    public Path setIsDirectory(Boolean isDirectory) {
        this.isDirectory = isDirectory;
        return this;
    }

    /**
     * Get the lastModified property: The lastModified property.
     *
     * @return the lastModified value.
     */
    public String getLastModified() {
        return this.lastModified;
    }

    /**
     * Set the lastModified property: The lastModified property.
     *
     * @param lastModified the lastModified value to set.
     * @return the Path object itself.
     */
    public Path setLastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    /**
     * Get the contentLength property: The contentLength property.
     *
     * @return the contentLength value.
     */
    public Long getContentLength() {
        return this.contentLength;
    }

    /**
     * Set the contentLength property: The contentLength property.
     *
     * @param contentLength the contentLength value to set.
     * @return the Path object itself.
     */
    public Path setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    /**
     * Get the owner property: The owner property.
     *
     * @return the owner value.
     */
    public String getOwner() {
        return this.owner;
    }

    /**
     * Set the owner property: The owner property.
     *
     * @param owner the owner value to set.
     * @return the Path object itself.
     */
    public Path setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get the group property: The group property.
     *
     * @return the group value.
     */
    public String getGroup() {
        return this.group;
    }

    /**
     * Set the group property: The group property.
     *
     * @param group the group value to set.
     * @return the Path object itself.
     */
    public Path setGroup(String group) {
        this.group = group;
        return this;
    }

    /**
     * Get the permissions property: The permissions property.
     *
     * @return the permissions value.
     */
    public String getPermissions() {
        return this.permissions;
    }

    /**
     * Set the permissions property: The permissions property.
     *
     * @param permissions the permissions value to set.
     * @return the Path object itself.
     */
    public Path setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    /**
     * Get the encryptionScope property: The name of the encryption scope under which the blob is encrypted.
     *
     * @return the encryptionScope value.
     */
    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    /**
     * Set the encryptionScope property: The name of the encryption scope under which the blob is encrypted.
     *
     * @param encryptionScope the encryptionScope value to set.
     * @return the Path object itself.
     */
    public Path setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    /**
     * Get the creationTime property: The creationTime property.
     *
     * @return the creationTime value.
     */
    public String getCreationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: The creationTime property.
     *
     * @param creationTime the creationTime value to set.
     * @return the Path object itself.
     */
    public Path setCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the expiryTime property: The expiryTime property.
     *
     * @return the expiryTime value.
     */
    public String getExpiryTime() {
        return this.expiryTime;
    }

    /**
     * Set the expiryTime property: The expiryTime property.
     *
     * @param expiryTime the expiryTime value to set.
     * @return the Path object itself.
     */
    public Path setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    /**
     * Get the encryptionContext property: The EncryptionContext property.
     *
     * @return the encryptionContext value.
     */
    public String getEncryptionContext() {
        return this.encryptionContext;
    }

    /**
     * Set the encryptionContext property: The EncryptionContext property.
     *
     * @param encryptionContext the encryptionContext value to set.
     * @return the Path object itself.
     */
    public Path setEncryptionContext(String encryptionContext) {
        this.encryptionContext = encryptionContext;
        return this;
    }

    /**
     * Get the eTag property: The etag property.
     *
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The etag property.
     *
     * @param eTag the eTag value to set.
     * @return the Path object itself.
     */
    public Path setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        if (isDirectory != null) {
            jsonWriter.writeStringField("isDirectory", String.valueOf(this.isDirectory));
        }
        jsonWriter.writeStringField("lastModified", this.lastModified);
        if (contentLength != null) {
            jsonWriter.writeStringField("contentLength", String.valueOf(this.contentLength));
        }
        jsonWriter.writeStringField("owner", this.owner);
        jsonWriter.writeStringField("group", this.group);
        jsonWriter.writeStringField("permissions", this.permissions);
        jsonWriter.writeStringField("EncryptionScope", this.encryptionScope);
        jsonWriter.writeStringField("creationTime", this.creationTime);
        jsonWriter.writeStringField("expiryTime", this.expiryTime);
        jsonWriter.writeStringField("EncryptionContext", this.encryptionContext);
        jsonWriter.writeStringField("etag", this.eTag);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Path from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Path if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException IOException If an error occurs while reading the Path.
     * @throws IllegalStateException If a token is not an allowed type.
     */
    public static Path fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Path deserializedPath = new Path();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPath.name = reader.getString();
                } else if ("isDirectory".equals(fieldName)) {
                    JsonToken token = reader.currentToken();
                    if (token == JsonToken.STRING) {
                        deserializedPath.isDirectory = Boolean.parseBoolean(reader.getString());
                    } else if (token == JsonToken.BOOLEAN) {
                        deserializedPath.isDirectory = reader.getBoolean();
                    } else if (token == JsonToken.NULL) {
                        deserializedPath.isDirectory = null;
                    } else {
                        throw new IllegalStateException(
                            "Invalid token, expected one of STRING, BOOLEAN, or NULL. Was " + token);
                    }
                } else if ("lastModified".equals(fieldName)) {
                    deserializedPath.lastModified = reader.getString();
                } else if ("contentLength".equals(fieldName)) {
                    JsonToken token = reader.currentToken();
                    if (token == JsonToken.STRING) {
                        deserializedPath.contentLength = Long.parseLong(reader.getString());
                    } else if (token == JsonToken.NUMBER) {
                        deserializedPath.contentLength = reader.getLong();
                    } else if (token == JsonToken.NULL) {
                        deserializedPath.contentLength = null;
                    } else {
                        throw new IllegalStateException(
                            "Invalid token, expected one of STRING, NUMBER, or NULL. Was " + token);
                    }
                } else if ("owner".equals(fieldName)) {
                    deserializedPath.owner = reader.getString();
                } else if ("group".equals(fieldName)) {
                    deserializedPath.group = reader.getString();
                } else if ("permissions".equals(fieldName)) {
                    deserializedPath.permissions = reader.getString();
                } else if ("EncryptionScope".equals(fieldName)) {
                    deserializedPath.encryptionScope = reader.getString();
                } else if ("creationTime".equals(fieldName)) {
                    deserializedPath.creationTime = reader.getString();
                } else if ("expiryTime".equals(fieldName)) {
                    deserializedPath.expiryTime = reader.getString();
                } else if ("EncryptionContext".equals(fieldName)) {
                    deserializedPath.encryptionContext = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedPath.eTag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedPath;
        });
    }
}
