/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.datalake.implementation.models.BlobPropertiesInternal;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobItemInternal
implements XmlSerializable<BlobItemInternal> {
    private String name;
    private boolean deleted;
    private String snapshot;
    private String versionId;
    private Boolean isCurrentVersion;
    private BlobPropertiesInternal properties;
    private String deletionId;

    public String getName() {
        return this.name;
    }

    public BlobItemInternal setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public BlobItemInternal setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public BlobItemInternal setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public BlobItemInternal setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    public BlobItemInternal setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    public BlobPropertiesInternal getProperties() {
        return this.properties;
    }

    public BlobItemInternal setProperties(BlobPropertiesInternal properties) {
        this.properties = properties;
        return this;
    }

    public String getDeletionId() {
        return this.deletionId;
    }

    public BlobItemInternal setDeletionId(String deletionId) {
        this.deletionId = deletionId;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blob" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeStringElement("VersionId", this.versionId);
        xmlWriter.writeBooleanElement("IsCurrentVersion", this.isCurrentVersion);
        xmlWriter.writeXml((XmlSerializable)this.properties, "Properties");
        xmlWriter.writeStringElement("DeletionId", this.deletionId);
        return xmlWriter.writeEndElement();
    }

    public static BlobItemInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobItemInternal.fromXml(xmlReader, null);
    }

    public static BlobItemInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blob" : rootElementName;
        return (BlobItemInternal)xmlReader.readObject(finalRootElementName, reader -> {
            BlobItemInternal deserializedBlobItemInternal = new BlobItemInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.name = reader.getStringElement();
                    continue;
                }
                if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.deleted = reader.getBooleanElement();
                    continue;
                }
                if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.snapshot = reader.getStringElement();
                    continue;
                }
                if ("VersionId".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.versionId = reader.getStringElement();
                    continue;
                }
                if ("IsCurrentVersion".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.isCurrentVersion = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.properties = BlobPropertiesInternal.fromXml(reader, "Properties");
                    continue;
                }
                if ("DeletionId".equals(elementName.getLocalPart())) {
                    deserializedBlobItemInternal.deletionId = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobItemInternal;
        });
    }
}

