/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.credentials.SasTokenCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeFileClient.class, DataLakeFileAsyncClient.class, DataLakeDirectoryClient.class, DataLakeDirectoryAsyncClient.class})
public final class DataLakePathClientBuilder {
    private final ClientLogger logger = new ClientLogger(DataLakePathClientBuilder.class);
    private final BlobClientBuilder blobClientBuilder;
    private String endpoint;
    private String accountName;
    private String fileSystemName;
    private String pathName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private SasTokenCredential sasTokenCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> additionalPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions = new HttpLogOptions();
    private RequestRetryOptions retryOptions = new RequestRetryOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private DataLakeServiceVersion version;

    public DataLakePathClientBuilder() {
        this.logOptions = DataLakePathClientBuilder.getDefaultHttpLogOptions();
        this.blobClientBuilder = new BlobClientBuilder();
    }

    public DataLakeFileClient buildFileClient() {
        return new DataLakeFileClient(this.buildFileAsyncClient(), this.blobClientBuilder.buildClient().getBlockBlobClient());
    }

    public DataLakeFileAsyncClient buildFileAsyncClient() {
        Objects.requireNonNull(this.pathName, "'pathName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null");
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty((CharSequence)this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.sasTokenCredential, this.endpoint, this.retryOptions, this.logOptions, this.httpClient, this.additionalPolicies, this.configuration, this.logger);
        return new DataLakeFileAsyncClient(pipeline, String.format("%s/%s/%s", this.endpoint, dataLakeFileSystemName, this.pathName), serviceVersion, this.accountName, dataLakeFileSystemName, this.pathName, this.blobClientBuilder.buildAsyncClient().getBlockBlobAsyncClient());
    }

    public DataLakeDirectoryClient buildDirectoryClient() {
        return new DataLakeDirectoryClient(this.buildDirectoryAsyncClient(), this.blobClientBuilder.buildClient().getBlockBlobClient());
    }

    public DataLakeDirectoryAsyncClient buildDirectoryAsyncClient() {
        Objects.requireNonNull(this.pathName, "'pathName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null");
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty((CharSequence)this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.sasTokenCredential, this.endpoint, this.retryOptions, this.logOptions, this.httpClient, this.additionalPolicies, this.configuration, this.logger);
        return new DataLakeDirectoryAsyncClient(pipeline, String.format("%s/%s/%s", this.endpoint, dataLakeFileSystemName, this.pathName), serviceVersion, this.accountName, dataLakeFileSystemName, this.pathName, this.blobClientBuilder.buildAsyncClient().getBlockBlobAsyncClient());
    }

    public DataLakePathClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakePathClientBuilder credential(TokenCredential credential) {
        this.blobClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakePathClientBuilder sasToken(String sasToken) {
        this.blobClientBuilder.sasToken(sasToken);
        this.sasTokenCredential = new SasTokenCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public DataLakePathClientBuilder setAnonymousAccess() {
        this.blobClientBuilder.setAnonymousAccess();
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.sasTokenCredential = null;
        return this;
    }

    public DataLakePathClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse((URL)url);
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            this.fileSystemName = parts.getBlobContainerName();
            this.pathName = Utility.urlEncode((String)parts.getBlobName());
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage DataLake endpoint url is malformed."));
        }
        return this;
    }

    public DataLakePathClientBuilder fileSystemName(String fileSystemName) {
        this.blobClientBuilder.containerName(fileSystemName);
        this.fileSystemName = fileSystemName;
        return this;
    }

    public DataLakePathClientBuilder pathName(String pathName) {
        this.blobClientBuilder.blobName(pathName);
        this.pathName = Utility.urlEncode((String)Utility.urlDecode((String)Objects.requireNonNull(pathName, "'pathName' cannot be null.")));
        return this;
    }

    public DataLakePathClientBuilder httpClient(HttpClient httpClient) {
        this.blobClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public DataLakePathClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobClientBuilder.addPolicy(pipelinePolicy);
        this.additionalPolicies.add(Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null"));
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public DataLakePathClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public DataLakePathClientBuilder configuration(Configuration configuration) {
        this.blobClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakePathClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobClientBuilder.retryOptions(retryOptions);
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public DataLakePathClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DataLakePathClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }
}

