/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientImpl;
import com.azure.storage.file.datalake.implementation.models.LeaseAccessConditions;
import com.azure.storage.file.datalake.implementation.models.ModifiedAccessConditions;
import com.azure.storage.file.datalake.implementation.models.PathExpiryOptions;
import com.azure.storage.file.datalake.implementation.models.PathGetPropertiesAction;
import com.azure.storage.file.datalake.implementation.models.PathLeaseAction;
import com.azure.storage.file.datalake.implementation.models.PathRenameMode;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathSetAccessControlRecursiveMode;
import com.azure.storage.file.datalake.implementation.models.PathUpdateAction;
import com.azure.storage.file.datalake.implementation.models.PathsAppendDataResponse;
import com.azure.storage.file.datalake.implementation.models.PathsCreateResponse;
import com.azure.storage.file.datalake.implementation.models.PathsDeleteResponse;
import com.azure.storage.file.datalake.implementation.models.PathsFlushDataResponse;
import com.azure.storage.file.datalake.implementation.models.PathsGetPropertiesResponse;
import com.azure.storage.file.datalake.implementation.models.PathsLeaseResponse;
import com.azure.storage.file.datalake.implementation.models.PathsReadResponse;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlRecursiveResponse;
import com.azure.storage.file.datalake.implementation.models.PathsSetAccessControlResponse;
import com.azure.storage.file.datalake.implementation.models.PathsSetExpiryResponse;
import com.azure.storage.file.datalake.implementation.models.PathsUpdateResponse;
import com.azure.storage.file.datalake.implementation.models.SourceModifiedAccessConditions;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PathsImpl {
    private PathsService service;
    private DataLakeStorageClientImpl client;

    public PathsImpl(DataLakeStorageClientImpl client) {
        this.service = (PathsService)RestProxy.create(PathsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<PathsCreateResponse> createWithRestResponseAsync(Context context) {
        PathResourceType resource = null;
        String continuation = null;
        PathRenameMode mode = null;
        String renameSource = null;
        String sourceLeaseId = null;
        String properties = null;
        String permissions = null;
        String umask = null;
        String requestId = null;
        Integer timeout = null;
        String cacheControl = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        String contentType = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.create(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), resource, continuation, mode, renameSource, sourceLeaseId, properties, permissions, umask, requestId, timeout, this.client.getVersion(), cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, context);
    }

    public Mono<PathsCreateResponse> createWithRestResponseAsync(PathResourceType resource, String continuation, PathRenameMode mode, String renameSource, String sourceLeaseId, String properties, String permissions, String umask, String requestId, Integer timeout, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String cacheControl = null;
        if (pathHttpHeaders != null) {
            cacheControl = pathHttpHeaders.getCacheControl();
        }
        String contentEncoding = null;
        if (pathHttpHeaders != null) {
            contentEncoding = pathHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (pathHttpHeaders != null) {
            contentLanguage = pathHttpHeaders.getContentLanguage();
        }
        String contentDisposition = null;
        if (pathHttpHeaders != null) {
            contentDisposition = pathHttpHeaders.getContentDisposition();
        }
        String contentType = null;
        if (pathHttpHeaders != null) {
            contentType = pathHttpHeaders.getContentType();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        String sourceIfMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatch = sourceModifiedAccessConditions.getSourceIfMatch();
        }
        String sourceIfNoneMatch = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatch = sourceModifiedAccessConditions.getSourceIfNoneMatch();
        }
        OffsetDateTime sourceIfModifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfModifiedSince = sourceModifiedAccessConditions.getSourceIfModifiedSince();
        }
        OffsetDateTime sourceIfUnmodifiedSince = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfUnmodifiedSince = sourceModifiedAccessConditions.getSourceIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.create(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), resource, continuation, mode, renameSource, sourceLeaseId, properties, permissions, umask, requestId, timeout, this.client.getVersion(), cacheControl, contentEncoding, contentLanguage, contentDisposition, contentType, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, context);
    }

    public Mono<PathsUpdateResponse> updateWithRestResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, Context context) {
        Integer maxRecords = null;
        String continuation = null;
        Boolean forceFlag = null;
        Long position = null;
        Boolean retainUncommittedData = null;
        Boolean close = null;
        Long contentLength = null;
        String properties = null;
        String owner = null;
        String group = null;
        String permissions = null;
        String acl = null;
        String requestId = null;
        Integer timeout = null;
        String cacheControl = null;
        String contentType = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String contentMd5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.update(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, body, requestId, timeout, this.client.getVersion(), contentMd5Converted, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsUpdateResponse> updateWithRestResponseAsync(PathUpdateAction action, PathSetAccessControlRecursiveMode mode, Flux<ByteBuffer> body, Integer maxRecords, String continuation, Boolean forceFlag, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String properties, String owner, String group, String permissions, String acl, String requestId, Integer timeout, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        byte[] contentMd5 = null;
        if (pathHttpHeaders != null) {
            contentMd5 = pathHttpHeaders.getContentMd5();
        }
        String cacheControl = null;
        if (pathHttpHeaders != null) {
            cacheControl = pathHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (pathHttpHeaders != null) {
            contentType = pathHttpHeaders.getContentType();
        }
        String contentDisposition = null;
        if (pathHttpHeaders != null) {
            contentDisposition = pathHttpHeaders.getContentDisposition();
        }
        String contentEncoding = null;
        if (pathHttpHeaders != null) {
            contentEncoding = pathHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (pathHttpHeaders != null) {
            contentLanguage = pathHttpHeaders.getContentLanguage();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.update(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), action, maxRecords, continuation, mode, forceFlag, position, retainUncommittedData, close, contentLength, properties, owner, group, permissions, acl, body, requestId, timeout, this.client.getVersion(), contentMd5Converted, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsLeaseResponse> leaseWithRestResponseAsync(PathLeaseAction xMsLeaseAction, Context context) {
        Integer xMsLeaseDuration = null;
        Integer xMsLeaseBreakPeriod = null;
        String proposedLeaseId = null;
        String requestId = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.lease(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), xMsLeaseAction, xMsLeaseDuration, xMsLeaseBreakPeriod, proposedLeaseId, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsLeaseResponse> leaseWithRestResponseAsync(PathLeaseAction xMsLeaseAction, Integer xMsLeaseDuration, Integer xMsLeaseBreakPeriod, String proposedLeaseId, String requestId, Integer timeout, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.lease(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), xMsLeaseAction, xMsLeaseDuration, xMsLeaseBreakPeriod, proposedLeaseId, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsReadResponse> readWithRestResponseAsync(Context context) {
        String range = null;
        Boolean xMsRangeGetContentMd5 = null;
        String requestId = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.read(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), range, xMsRangeGetContentMd5, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsReadResponse> readWithRestResponseAsync(String range, Boolean xMsRangeGetContentMd5, String requestId, Integer timeout, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.read(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), range, xMsRangeGetContentMd5, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context) {
        PathGetPropertiesAction action = null;
        Boolean upn = null;
        String requestId = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getProperties(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), action, upn, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsGetPropertiesResponse> getPropertiesWithRestResponseAsync(PathGetPropertiesAction action, Boolean upn, String requestId, Integer timeout, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getProperties(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), action, upn, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsDeleteResponse> deleteWithRestResponseAsync(Context context) {
        Boolean recursive = null;
        String continuation = null;
        String requestId = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), recursive, continuation, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsDeleteResponse> deleteWithRestResponseAsync(Boolean recursive, String continuation, String requestId, Integer timeout, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), recursive, continuation, requestId, timeout, this.client.getVersion(), leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsSetAccessControlResponse> setAccessControlWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String owner = null;
        String group = null;
        String permissions = null;
        String acl = null;
        String requestId = null;
        String action = "setAccessControl";
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setAccessControl(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, owner, group, permissions, acl, requestId, this.client.getVersion(), "setAccessControl", leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsSetAccessControlResponse> setAccessControlWithRestResponseAsync(Integer timeout, String owner, String group, String permissions, String acl, String requestId, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "setAccessControl";
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControl(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, owner, group, permissions, acl, requestId, this.client.getVersion(), "setAccessControl", leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsSetAccessControlRecursiveResponse> setAccessControlRecursiveWithRestResponseAsync(PathSetAccessControlRecursiveMode mode, Context context) {
        Integer timeout = null;
        String continuation = null;
        Boolean forceFlag = null;
        Integer maxRecords = null;
        String acl = null;
        String requestId = null;
        String action = "setAccessControlRecursive";
        return this.service.setAccessControlRecursive(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "setAccessControlRecursive", context);
    }

    public Mono<PathsSetAccessControlRecursiveResponse> setAccessControlRecursiveWithRestResponseAsync(PathSetAccessControlRecursiveMode mode, Integer timeout, String continuation, Boolean forceFlag, Integer maxRecords, String acl, String requestId, Context context) {
        String action = "setAccessControlRecursive";
        return this.service.setAccessControlRecursive(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, continuation, mode, forceFlag, maxRecords, acl, requestId, this.client.getVersion(), "setAccessControlRecursive", context);
    }

    public Mono<PathsFlushDataResponse> flushDataWithRestResponseAsync(Context context) {
        Integer timeout = null;
        Long position = null;
        Boolean retainUncommittedData = null;
        Boolean close = null;
        Long contentLength = null;
        String requestId = null;
        String action = "flush";
        String cacheControl = null;
        String contentType = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String contentMd5Converted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.flushData(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, position, retainUncommittedData, close, contentLength, requestId, this.client.getVersion(), "flush", contentMd5Converted, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsFlushDataResponse> flushDataWithRestResponseAsync(Integer timeout, Long position, Boolean retainUncommittedData, Boolean close, Long contentLength, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        String action = "flush";
        byte[] contentMd5 = null;
        if (pathHttpHeaders != null) {
            contentMd5 = pathHttpHeaders.getContentMd5();
        }
        String cacheControl = null;
        if (pathHttpHeaders != null) {
            cacheControl = pathHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (pathHttpHeaders != null) {
            contentType = pathHttpHeaders.getContentType();
        }
        String contentDisposition = null;
        if (pathHttpHeaders != null) {
            contentDisposition = pathHttpHeaders.getContentDisposition();
        }
        String contentEncoding = null;
        if (pathHttpHeaders != null) {
            contentEncoding = pathHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (pathHttpHeaders != null) {
            contentLanguage = pathHttpHeaders.getContentLanguage();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String ifMatch = null;
        if (modifiedAccessConditions != null) {
            ifMatch = modifiedAccessConditions.getIfMatch();
        }
        String ifNoneMatch = null;
        if (modifiedAccessConditions != null) {
            ifNoneMatch = modifiedAccessConditions.getIfNoneMatch();
        }
        OffsetDateTime ifModifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifModifiedSince = modifiedAccessConditions.getIfModifiedSince();
        }
        OffsetDateTime ifUnmodifiedSince = null;
        if (modifiedAccessConditions != null) {
            ifUnmodifiedSince = modifiedAccessConditions.getIfUnmodifiedSince();
        }
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.flushData(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, position, retainUncommittedData, close, contentLength, requestId, this.client.getVersion(), "flush", contentMd5Converted, cacheControl, contentType, contentDisposition, contentEncoding, contentLanguage, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, context);
    }

    public Mono<PathsAppendDataResponse> appendDataWithRestResponseAsync(Flux<ByteBuffer> body, Context context) {
        Long position = null;
        Integer timeout = null;
        Long contentLength = null;
        String requestId = null;
        String action = "append";
        String leaseId = null;
        String transactionalContentCrc64Converted = null;
        String transactionalContentHashConverted = null;
        return this.service.appendData(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), position, timeout, contentLength, transactionalContentCrc64Converted, body, requestId, this.client.getVersion(), "append", transactionalContentHashConverted, leaseId, context);
    }

    public Mono<PathsAppendDataResponse> appendDataWithRestResponseAsync(Flux<ByteBuffer> body, Long position, Integer timeout, Long contentLength, byte[] transactionalContentCrc64, String requestId, PathHttpHeaders pathHttpHeaders, LeaseAccessConditions leaseAccessConditions, Context context) {
        String action = "append";
        byte[] transactionalContentHash = null;
        if (pathHttpHeaders != null) {
            transactionalContentHash = pathHttpHeaders.getTransactionalContentHash();
        }
        String leaseId = null;
        if (leaseAccessConditions != null) {
            leaseId = leaseAccessConditions.getLeaseId();
        }
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        String transactionalContentHashConverted = Base64Util.encodeToString((byte[])transactionalContentHash);
        return this.service.appendData(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), position, timeout, contentLength, transactionalContentCrc64Converted, body, requestId, this.client.getVersion(), "append", transactionalContentHashConverted, leaseId, context);
    }

    public Mono<PathsSetExpiryResponse> setExpiryWithRestResponseAsync(PathExpiryOptions expiryOptions, Context context) {
        Integer timeout = null;
        String requestId = null;
        String expiresOn = null;
        String comp = "expiry";
        return this.service.setExpiry(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "expiry", context);
    }

    public Mono<PathsSetExpiryResponse> setExpiryWithRestResponseAsync(PathExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        return this.service.setExpiry(this.client.getFileSystem(), this.client.getPath1(), this.client.getUrl(), timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "expiry", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="DataLakeStorageClientPaths")
    private static interface PathsService {
        @Put(value="{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsCreateResponse> create(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="resource") PathResourceType var4, @QueryParam(value="continuation") String var5, @QueryParam(value="mode") PathRenameMode var6, @HeaderParam(value="x-ms-rename-source") String var7, @HeaderParam(value="x-ms-source-lease-id") String var8, @HeaderParam(value="x-ms-properties") String var9, @HeaderParam(value="x-ms-permissions") String var10, @HeaderParam(value="x-ms-umask") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="timeout") Integer var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-cache-control") String var15, @HeaderParam(value="x-ms-content-encoding") String var16, @HeaderParam(value="x-ms-content-language") String var17, @HeaderParam(value="x-ms-content-disposition") String var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="If-Match") String var21, @HeaderParam(value="If-None-Match") String var22, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var23, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var24, @HeaderParam(value="x-ms-source-if-match") String var25, @HeaderParam(value="x-ms-source-if-none-match") String var26, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var27, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var28, Context var29);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsUpdateResponse> update(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="action") PathUpdateAction var4, @QueryParam(value="maxRecords") Integer var5, @QueryParam(value="continuation") String var6, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var7, @QueryParam(value="forceFlag") Boolean var8, @QueryParam(value="position") Long var9, @QueryParam(value="retainUncommittedData") Boolean var10, @QueryParam(value="close") Boolean var11, @HeaderParam(value="Content-Length") Long var12, @HeaderParam(value="x-ms-properties") String var13, @HeaderParam(value="x-ms-owner") String var14, @HeaderParam(value="x-ms-group") String var15, @HeaderParam(value="x-ms-permissions") String var16, @HeaderParam(value="x-ms-acl") String var17, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var18, @HeaderParam(value="x-ms-client-request-id") String var19, @QueryParam(value="timeout") Integer var20, @HeaderParam(value="x-ms-version") String var21, @HeaderParam(value="x-ms-content-md5") String var22, @HeaderParam(value="x-ms-cache-control") String var23, @HeaderParam(value="x-ms-content-type") String var24, @HeaderParam(value="x-ms-content-disposition") String var25, @HeaderParam(value="x-ms-content-encoding") String var26, @HeaderParam(value="x-ms-content-language") String var27, @HeaderParam(value="x-ms-lease-id") String var28, @HeaderParam(value="If-Match") String var29, @HeaderParam(value="If-None-Match") String var30, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var31, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var32, Context var33);

        @Post(value="{filesystem}/{path}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsLeaseResponse> lease(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-lease-action") PathLeaseAction var4, @HeaderParam(value="x-ms-lease-duration") Integer var5, @HeaderParam(value="x-ms-lease-break-period") Integer var6, @HeaderParam(value="x-ms-proposed-lease-id") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var15, Context var16);

        @Get(value="{filesystem}/{path}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsReadResponse> read(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @HeaderParam(value="Range") String var4, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, Context var14);

        @Head(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsGetPropertiesResponse> getProperties(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="action") PathGetPropertiesAction var4, @QueryParam(value="upn") Boolean var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, Context var14);

        @Delete(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsDeleteResponse> delete(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="recursive") Boolean var4, @QueryParam(value="continuation") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, Context var14);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsSetAccessControlResponse> setAccessControl(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-owner") String var5, @HeaderParam(value="x-ms-group") String var6, @HeaderParam(value="x-ms-permissions") String var7, @HeaderParam(value="x-ms-acl") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-version") String var10, @QueryParam(value="action") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var15, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var16, Context var17);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsSetAccessControlRecursiveResponse> setAccessControlRecursive(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="continuation") String var5, @QueryParam(value="mode") PathSetAccessControlRecursiveMode var6, @QueryParam(value="forceFlag") Boolean var7, @QueryParam(value="maxRecords") Integer var8, @HeaderParam(value="x-ms-acl") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="action") String var12, Context var13);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsFlushDataResponse> flushData(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="position") Long var5, @QueryParam(value="retainUncommittedData") Boolean var6, @QueryParam(value="close") Boolean var7, @HeaderParam(value="Content-Length") Long var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-version") String var10, @QueryParam(value="action") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-cache-control") String var13, @HeaderParam(value="x-ms-content-type") String var14, @HeaderParam(value="x-ms-content-disposition") String var15, @HeaderParam(value="x-ms-content-encoding") String var16, @HeaderParam(value="x-ms-content-language") String var17, @HeaderParam(value="x-ms-lease-id") String var18, @HeaderParam(value="If-Match") String var19, @HeaderParam(value="If-None-Match") String var20, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var22, Context var23);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsAppendDataResponse> appendData(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="position") Long var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") Long var6, @HeaderParam(value="x-ms-content-crc64") String var7, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-version") String var10, @QueryParam(value="action") String var11, @HeaderParam(value="Content-MD5") String var12, @HeaderParam(value="x-ms-lease-id") String var13, Context var14);

        @Put(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageException.class)
        public Mono<PathsSetExpiryResponse> setExpiry(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="x-ms-expiry-option") PathExpiryOptions var7, @HeaderParam(value="x-ms-expiry-time") String var8, @QueryParam(value="comp") String var9, Context var10);
    }
}

