// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.datalake.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;

/**
 * Initializes a new instance of the DataLakeStorageClient type.
 */
public final class DataLakeStorageClientImpl {
    /**
     * The URL of the service account, container, or blob that is the targe of the desired operation.
     */
    private String url;

    /**
     * Gets The URL of the service account, container, or blob that is the targe of the desired operation.
     *
     * @return the url value.
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * Sets The URL of the service account, container, or blob that is the targe of the desired operation.
     *
     * @param url the url value.
     */
    DataLakeStorageClientImpl setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * The value must be "filesystem" for all filesystem operations.
     */
    private String resource;

    /**
     * Gets The value must be "filesystem" for all filesystem operations.
     *
     * @return the resource value.
     */
    public String getResource() {
        return this.resource;
    }

    /**
     * Sets The value must be "filesystem" for all filesystem operations.
     *
     * @param resource the resource value.
     */
    DataLakeStorageClientImpl setResource(String resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Specifies the version of the operation to use for this request.
     */
    private String version;

    /**
     * Gets Specifies the version of the operation to use for this request.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Sets Specifies the version of the operation to use for this request.
     *
     * @param version the version value.
     */
    DataLakeStorageClientImpl setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * The filesystem identifier.
     */
    private String fileSystem;

    /**
     * Gets The filesystem identifier.
     *
     * @return the fileSystem value.
     */
    public String getFileSystem() {
        return this.fileSystem;
    }

    /**
     * Sets The filesystem identifier.
     *
     * @param fileSystem the fileSystem value.
     */
    DataLakeStorageClientImpl setFileSystem(String fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    /**
     * The file or directory path.
     */
    private String path1;

    /**
     * Gets The file or directory path.
     *
     * @return the path1 value.
     */
    public String getPath1() {
        return this.path1;
    }

    /**
     * Sets The file or directory path.
     *
     * @param path1 the path1 value.
     */
    DataLakeStorageClientImpl setPath1(String path1) {
        this.path1 = path1;
        return this;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The ServicesImpl object to access its operations.
     */
    private ServicesImpl services;

    /**
     * Gets the ServicesImpl object to access its operations.
     *
     * @return the ServicesImpl object.
     */
    public ServicesImpl services() {
        return this.services;
    }

    /**
     * The FileSystemsImpl object to access its operations.
     */
    private FileSystemsImpl fileSystems;

    /**
     * Gets the FileSystemsImpl object to access its operations.
     *
     * @return the FileSystemsImpl object.
     */
    public FileSystemsImpl fileSystems() {
        return this.fileSystems;
    }

    /**
     * The PathsImpl object to access its operations.
     */
    private PathsImpl paths;

    /**
     * Gets the PathsImpl object to access its operations.
     *
     * @return the PathsImpl object.
     */
    public PathsImpl paths() {
        return this.paths;
    }

    /**
     * Initializes an instance of DataLakeStorageClient client.
     */
    public DataLakeStorageClientImpl() {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()).build());
    }

    /**
     * Initializes an instance of DataLakeStorageClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     */
    public DataLakeStorageClientImpl(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        this.services = new ServicesImpl(this);
        this.fileSystems = new FileSystemsImpl(this);
        this.paths = new PathsImpl(this);
    }
}
