/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class DataLakeDirectoryClient
extends DataLakePathClient {
    private final ClientLogger logger = new ClientLogger(DataLakeDirectoryClient.class);
    private final DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;

    DataLakeDirectoryClient(DataLakeDirectoryAsyncClient pathAsyncClient, BlockBlobClient blockBlobClient) {
        super(pathAsyncClient, blockBlobClient);
        this.dataLakeDirectoryAsyncClient = pathAsyncClient;
    }

    private DataLakeDirectoryClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.blockBlobClient);
        this.dataLakeDirectoryAsyncClient = new DataLakeDirectoryAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    public void delete() {
        this.deleteWithResponse(false, null, null, Context.NONE).getValue();
    }

    public Response<Void> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.dataLakePathAsyncClient.deleteWithResponse(recursive, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        return new DataLakeFileClient(this.dataLakeDirectoryAsyncClient.getFileAsyncClient(fileName), this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(fileName).buildBlockBlobClient());
    }

    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return (DataLakeFileClient)this.createFileWithResponse(fileName, null, null, null, null, requestConditions, null, null).getValue();
    }

    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createWithResponse(permissions, umask, headers, metadata, requestConditions, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeFileClient);
    }

    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE);
    }

    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    public DataLakeDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getSubdirectoryAsyncClient(subdirectoryName), this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(subdirectoryName).buildBlockBlobClient());
    }

    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName) {
        return this.createSubdirectory(subdirectoryName, false);
    }

    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return (DataLakeDirectoryClient)this.createSubdirectoryWithResponse(subdirectoryName, null, null, null, null, requestConditions, null, null).getValue();
    }

    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createWithResponse(permissions, umask, headers, metadata, requestConditions, timeout, context);
        return new SimpleResponse(response, (Object)dataLakeDirectoryClient);
    }

    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, false, null, null, Context.NONE);
    }

    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    public DataLakeDirectoryClient rename(String destinationFileSystem, String destinationPath) {
        return (DataLakeDirectoryClient)this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, Context.NONE).getValue();
    }

    public Response<DataLakeDirectoryClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout, Context context) {
        Mono<Response<DataLakePathClient>> response = this.renameWithResponse(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, context);
        Response resp = (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
        return new SimpleResponse(resp, (Object)new DataLakeDirectoryClient((DataLakePathClient)resp.getValue()));
    }
}

