/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.storage.file.datalake.implementation.DataLakeStorageClientImpl;

@ServiceClientBuilder(serviceClients={DataLakeStorageClientImpl.class})
public final class DataLakeStorageClientBuilder {
    private String url;
    private String resource;
    private String version;
    private String fileSystem;
    private String path1;
    private HttpPipeline pipeline;

    public DataLakeStorageClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public DataLakeStorageClientBuilder resource(String resource) {
        this.resource = resource;
        return this;
    }

    public DataLakeStorageClientBuilder version(String version) {
        this.version = version;
        return this;
    }

    public DataLakeStorageClientBuilder fileSystem(String fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public DataLakeStorageClientBuilder path1(String path1) {
        this.path1 = path1;
        return this;
    }

    public DataLakeStorageClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public DataLakeStorageClientImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        DataLakeStorageClientImpl client = new DataLakeStorageClientImpl(this.pipeline);
        if (this.url != null) {
            client.setUrl(this.url);
        }
        if (this.resource != null) {
            client.setResource(this.resource);
        } else {
            client.setResource("filesystem");
        }
        if (this.version != null) {
            client.setVersion(this.version);
        } else {
            client.setVersion("2020-02-10");
        }
        if (this.fileSystem != null) {
            client.setFileSystem(this.fileSystem);
        }
        if (this.path1 != null) {
            client.setPath1(this.path1);
        }
        return client;
    }
}

