/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsResponse;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.azure.storage.file.datalake.models.FileSystemProperties;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class DataLakeFileSystemAsyncClient {
    public static final String ROOT_FILESYSTEM_NAME = "$root";
    private static final String ROOT_DIRECTORY_NAME = "";
    private final ClientLogger logger = new ClientLogger(DataLakeFileSystemAsyncClient.class);
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final BlobContainerAsyncClient blobContainerAsyncClient;
    private final String accountName;
    private final String fileSystemName;
    private final DataLakeServiceVersion serviceVersion;

    DataLakeFileSystemAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, BlobContainerAsyncClient blobContainerAsyncClient) {
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.blobContainerAsyncClient = blobContainerAsyncClient;
    }

    public DataLakeFileAsyncClient getFileAsyncClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(fileName, null).getBlockBlobAsyncClient();
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), fileName, blockBlobAsyncClient);
    }

    public DataLakeDirectoryAsyncClient getDirectoryAsyncClient(String directoryName) {
        Objects.requireNonNull(directoryName, "'directoryName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(directoryName, null).getBlockBlobAsyncClient();
        return new DataLakeDirectoryAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), directoryName, blockBlobAsyncClient);
    }

    DataLakeDirectoryAsyncClient getRootDirectoryAsyncClient() {
        return this.getDirectoryAsyncClient(ROOT_DIRECTORY_NAME);
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    public String getFileSystemUrl() {
        return this.azureDataLakeStorage.getUrl() + "/" + this.fileSystemName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    public Mono<Void> create() {
        try {
            return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return this.blobContainerAsyncClient.createWithResponse(metadata, Transforms.toBlobPublicAccessType(accessType)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse(DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.deleteWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<FileSystemProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<FileSystemProperties>> getPropertiesWithResponse(String leaseId) {
        try {
            return this.blobContainerAsyncClient.getPropertiesWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toFileSystemProperties((BlobContainerProperties)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<PathItem> listPaths() {
        try {
            return this.listPaths(new ListPathsOptions());
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public PagedFlux<PathItem> listPaths(ListPathsOptions options) {
        return this.listPathsWithOptionalTimeout(options, null);
    }

    PagedFlux<PathItem> listPathsWithOptionalTimeout(ListPathsOptions options, Duration timeout) {
        Function<String, Mono> func = marker -> this.listPathsSegment((String)marker, options, timeout).map(response -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue().getPaths(), ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (Object)((FileSystemsListPathsHeaders)response.getDeserializedHeaders())));
        return new PagedFlux(() -> (Mono)func.apply(null), func).mapPage(Transforms::toPathItem);
    }

    private Mono<FileSystemsListPathsResponse> listPathsSegment(String marker, ListPathsOptions options, Duration timeout) {
        options = options == null ? new ListPathsOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureDataLakeStorage.getFileSystems().listPathsWithResponseAsync(options.isRecursive(), null, null, marker, options.getPath(), options.getMaxResults(), options.isUserPrincipalNameReturned(), Context.NONE), (Duration)timeout);
    }

    public Mono<DataLakeFileAsyncClient> createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    public Mono<DataLakeFileAsyncClient> createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        try {
            return this.createFileWithResponse(fileName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeFileAsyncClient dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
            return dataLakeFileAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeFileAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> deleteFile(String fileName) {
        try {
            return this.deleteFileWithResponse(fileName, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions) {
        try {
            return this.getFileAsyncClient(fileName).deleteWithResponse(requestConditions);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName) {
        return this.createDirectory(directoryName, false);
    }

    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        try {
            return this.createDirectoryWithResponse(directoryName, null, null, null, null, requestConditions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<DataLakeDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        try {
            DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient = this.getDirectoryAsyncClient(directoryName);
            return dataLakeDirectoryAsyncClient.createWithResponse(permissions, umask, headers, metadata, requestConditions).map(response -> new SimpleResponse(response, (Object)dataLakeDirectoryAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> deleteDirectory(String directoryName) {
        return this.deleteDirectoryWithResponse(directoryName, false, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions) {
        return this.getDirectoryAsyncClient(directoryName).deleteWithResponse(recursive, requestConditions);
    }

    public Mono<Void> setAccessPolicy(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers) {
        try {
            return this.setAccessPolicyWithResponse(accessType, identifiers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers, DataLakeRequestConditions requestConditions) {
        try {
            return this.blobContainerAsyncClient.setAccessPolicyWithResponse(Transforms.toBlobPublicAccessType(accessType), Transforms.toBlobIdentifierList(identifiers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<FileSystemAccessPolicies> getAccessPolicy() {
        try {
            return this.getAccessPolicyWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<FileSystemAccessPolicies>> getAccessPolicyWithResponse(String leaseId) {
        try {
            return this.blobContainerAsyncClient.getAccessPolicyWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse(response, (Object)Transforms.toFileSystemAccessPolicies((BlobContainerAccessPolicies)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    BlobContainerAsyncClient getBlobContainerAsyncClient() {
        return this.blobContainerAsyncClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateUserDelegationSas(userDelegationKey, accountName, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), context);
    }
}

