/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceAsyncClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.FileSystemItem;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.FileSystemUndeleteOptions;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;

public class DataLakeServiceClient {
    private final ClientLogger logger = new ClientLogger(DataLakeServiceClient.class);
    private final DataLakeServiceAsyncClient dataLakeServiceAsyncClient;
    private final BlobServiceClient blobServiceClient;

    DataLakeServiceClient(DataLakeServiceAsyncClient dataLakeServiceAsyncClient, BlobServiceClient blobServiceClient) {
        this.dataLakeServiceAsyncClient = dataLakeServiceAsyncClient;
        this.blobServiceClient = blobServiceClient;
    }

    public DataLakeFileSystemClient getFileSystemClient(String fileSystemName) {
        return new DataLakeFileSystemClient(this.dataLakeServiceAsyncClient.getFileSystemAsyncClient(fileSystemName), this.blobServiceClient.getBlobContainerClient(fileSystemName));
    }

    public HttpPipeline getHttpPipeline() {
        return this.dataLakeServiceAsyncClient.getHttpPipeline();
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.dataLakeServiceAsyncClient.getServiceVersion();
    }

    public DataLakeFileSystemClient createFileSystem(String fileSystemName) {
        return (DataLakeFileSystemClient)this.createFileSystemWithResponse(fileSystemName, null, null, Context.NONE).getValue();
    }

    public Response<DataLakeFileSystemClient> createFileSystemWithResponse(String fileSystemName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        DataLakeFileSystemClient client = this.getFileSystemClient(fileSystemName);
        return new SimpleResponse(client.createWithResponse(metadata, accessType, null, context), (Object)client);
    }

    public void deleteFileSystem(String fileSystemName) {
        this.deleteFileSystemWithResponse(fileSystemName, null, Context.NONE).getValue();
    }

    public Response<Void> deleteFileSystemWithResponse(String fileSystemName, DataLakeRequestConditions requestConditions, Context context) {
        return this.getFileSystemClient(fileSystemName).deleteWithResponse(requestConditions, null, context);
    }

    public String getAccountUrl() {
        return this.dataLakeServiceAsyncClient.getAccountUrl();
    }

    public PagedIterable<FileSystemItem> listFileSystems() {
        return this.listFileSystems(new ListFileSystemsOptions(), null);
    }

    public PagedIterable<FileSystemItem> listFileSystems(ListFileSystemsOptions options, Duration timeout) {
        return new PagedIterable(this.dataLakeServiceAsyncClient.listFileSystemsWithOptionalTimeout(options, timeout));
    }

    public UserDelegationKey getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return (UserDelegationKey)this.getUserDelegationKeyWithResponse(start, expiry, null, Context.NONE).getValue();
    }

    public Response<UserDelegationKey> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Duration timeout, Context context) {
        return (Response)DataLakeImplUtils.returnOrConvertException(() -> {
            Response response = this.blobServiceClient.getUserDelegationKeyWithResponse(start, expiry, timeout, context);
            return new SimpleResponse(response, (Object)Transforms.toDataLakeUserDelegationKey((com.azure.storage.blob.models.UserDelegationKey)response.getValue()));
        }, this.logger);
    }

    public String getAccountName() {
        return this.dataLakeServiceAsyncClient.getAccountName();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.dataLakeServiceAsyncClient.generateAccountSas(accountSasSignatureValues);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.dataLakeServiceAsyncClient.generateAccountSas(accountSasSignatureValues, context);
    }

    public DataLakeFileSystemClient undeleteFileSystem(String deletedFileSystemName, String deletedFileSystemVersion) {
        return (DataLakeFileSystemClient)this.undeleteFileSystemWithResponse(new FileSystemUndeleteOptions(deletedFileSystemName, deletedFileSystemVersion), null, Context.NONE).getValue();
    }

    public Response<DataLakeFileSystemClient> undeleteFileSystemWithResponse(FileSystemUndeleteOptions options, Duration timeout, Context context) {
        return (Response)DataLakeImplUtils.returnOrConvertException(() -> {
            Response response = this.blobServiceClient.undeleteBlobContainerWithResponse(Transforms.toBlobContainerUndeleteOptions(options), timeout, context);
            return new SimpleResponse(response, (Object)this.getFileSystemClient(((BlobContainerClient)response.getValue()).getBlobContainerName()));
        }, this.logger);
    }
}

