/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.TransformUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeFileSystemClient.class, DataLakeFileSystemAsyncClient.class})
public class DataLakeFileSystemClientBuilder
implements TokenCredentialTrait<DataLakeFileSystemClientBuilder>,
AzureNamedKeyCredentialTrait<DataLakeFileSystemClientBuilder>,
AzureSasCredentialTrait<DataLakeFileSystemClientBuilder>,
HttpTrait<DataLakeFileSystemClientBuilder>,
ConfigurationTrait<DataLakeFileSystemClientBuilder>,
EndpointTrait<DataLakeFileSystemClientBuilder> {
    private final ClientLogger logger = new ClientLogger(DataLakeFileSystemClientBuilder.class);
    private final BlobContainerClientBuilder blobContainerClientBuilder;
    private String endpoint;
    private String accountName;
    private String fileSystemName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private DataLakeServiceVersion version;

    public DataLakeFileSystemClientBuilder() {
        this.logOptions = DataLakeFileSystemClientBuilder.getDefaultHttpLogOptions();
        this.blobContainerClientBuilder = new BlobContainerClientBuilder();
        this.blobContainerClientBuilder.addPolicy((HttpPipelinePolicy)BuilderHelper.getBlobUserAgentModificationPolicy());
    }

    public DataLakeFileSystemClient buildClient() {
        return new DataLakeFileSystemClient(this.buildAsyncClient(), this.blobContainerClientBuilder.buildClient());
    }

    public DataLakeFileSystemAsyncClient buildAsyncClient() {
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty((CharSequence)this.fileSystemName) ? "$root" : this.fileSystemName;
        DataLakeServiceVersion serviceVersion = this.version != null ? this.version : DataLakeServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger);
        return new DataLakeFileSystemAsyncClient(pipeline, this.endpoint, serviceVersion, this.accountName, dataLakeFileSystemName, this.blobContainerClientBuilder.buildAsyncClient());
    }

    public DataLakeFileSystemClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobContainerClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse((URL)url);
            this.accountName = parts.getAccountName();
            this.fileSystemName = parts.getBlobContainerName() == null ? this.fileSystemName : parts.getBlobContainerName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage Datalake endpoint url is malformed."));
        }
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential((AzureNamedKeyCredential)credential));
    }

    public DataLakeFileSystemClientBuilder credential(TokenCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder sasToken(String sasToken) {
        this.blobContainerClientBuilder.sasToken(sasToken);
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(AzureSasCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder setAnonymousAccess() {
        this.blobContainerClientBuilder.setAnonymousAccess();
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        this.sasToken = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder fileSystemName(String fileSystemName) {
        this.blobContainerClientBuilder.containerName(fileSystemName);
        this.fileSystemName = fileSystemName;
        return this;
    }

    public DataLakeFileSystemClientBuilder httpClient(HttpClient httpClient) {
        this.blobContainerClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public DataLakeFileSystemClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobContainerClientBuilder.addPolicy(pipelinePolicy);
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public DataLakeFileSystemClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobContainerClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder configuration(Configuration configuration) {
        this.blobContainerClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakeFileSystemClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobContainerClientBuilder.retryOptions(retryOptions);
        this.retryOptions = retryOptions;
        return this;
    }

    public DataLakeFileSystemClientBuilder retryOptions(RetryOptions retryOptions) {
        this.blobContainerClientBuilder.retryOptions(retryOptions);
        this.coreRetryOptions = retryOptions;
        return this;
    }

    public DataLakeFileSystemClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobContainerClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public DataLakeFileSystemClientBuilder clientOptions(ClientOptions clientOptions) {
        this.blobContainerClientBuilder.clientOptions(clientOptions);
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobContainerClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }
}

