/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.ServicesListSharesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.ShareItemInternal;
import com.azure.storage.file.share.implementation.models.SharePropertiesInternal;
import com.azure.storage.file.share.models.ShareFileDownloadHeaders;
import com.azure.storage.file.share.models.ShareItem;
import com.azure.storage.file.share.models.ShareProperties;
import com.azure.storage.file.share.models.ShareProtocols;
import com.azure.storage.file.share.models.ShareSnapshotsDeleteOptionType;
import java.io.IOException;

public class ModelHelper {
    private static final SerializerAdapter SERIALIZER = new JacksonAdapter();
    private static final ClientLogger LOGGER = new ClientLogger(ModelHelper.class);
    private static final long MAX_FILE_PUT_RANGE_BYTES = 0x400000L;
    private static final int FILE_DEFAULT_NUMBER_OF_BUFFERS = 8;

    public static ParallelTransferOptions populateAndApplyDefaults(ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize;
        ParallelTransferOptions parallelTransferOptions = other = other == null ? new ParallelTransferOptions() : other;
        if (other.getBlockSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.blockSize", (long)other.getBlockSizeLong(), (long)1L, (long)0x400000L);
        }
        if (other.getMaxSingleUploadSizeLong() != null) {
            StorageImplUtils.assertInBounds((String)"ParallelTransferOptions.maxSingleUploadSize", (long)other.getMaxSingleUploadSizeLong(), (long)1L, (long)0x400000L);
        }
        if ((blockSize = other.getBlockSizeLong()) == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x400000L;
        }
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressReceiver(other.getProgressReceiver()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static DeleteSnapshotsOptionType toDeleteSnapshotsOptionType(ShareSnapshotsDeleteOptionType option) {
        if (option == null) {
            return null;
        }
        switch (option) {
            case INCLUDE: {
                return DeleteSnapshotsOptionType.INCLUDE;
            }
            case INCLUDE_WITH_LEASED: {
                return DeleteSnapshotsOptionType.INCLUDE_LEASED;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid " + ((Object)((Object)option)).getClass()));
    }

    public static ShareItem populateShareItem(ShareItemInternal shareItemInternal) {
        ShareItem item = new ShareItem();
        item.setName(shareItemInternal.getName());
        item.setSnapshot(shareItemInternal.getSnapshot());
        item.setDeleted(shareItemInternal.isDeleted());
        item.setVersion(shareItemInternal.getVersion());
        item.setProperties(ModelHelper.populateShareProperties(shareItemInternal.getProperties()));
        item.setMetadata(shareItemInternal.getMetadata());
        return item;
    }

    public static ShareProperties populateShareProperties(SharePropertiesInternal sharePropertiesInternal) {
        ShareProperties properties = new ShareProperties();
        properties.setLastModified(sharePropertiesInternal.getLastModified());
        properties.setETag(sharePropertiesInternal.getETag());
        properties.setQuota(sharePropertiesInternal.getQuota());
        properties.setProvisionedIops(sharePropertiesInternal.getProvisionedIops());
        properties.setProvisionedIngressMBps(sharePropertiesInternal.getProvisionedIngressMBps());
        properties.setProvisionedEgressMBps(sharePropertiesInternal.getProvisionedEgressMBps());
        properties.setNextAllowedQuotaDowngradeTime(sharePropertiesInternal.getNextAllowedQuotaDowngradeTime());
        properties.setDeletedTime(sharePropertiesInternal.getDeletedTime());
        properties.setRemainingRetentionDays(sharePropertiesInternal.getRemainingRetentionDays());
        properties.setAccessTier(sharePropertiesInternal.getAccessTier());
        properties.setAccessTierChangeTime(sharePropertiesInternal.getAccessTierChangeTime());
        properties.setAccessTierTransitionState(sharePropertiesInternal.getAccessTierTransitionState());
        properties.setLeaseStatus(sharePropertiesInternal.getLeaseStatus());
        properties.setLeaseState(sharePropertiesInternal.getLeaseState());
        properties.setLeaseDuration(sharePropertiesInternal.getLeaseDuration());
        properties.setProtocols(ModelHelper.parseShareProtocols(sharePropertiesInternal.getEnabledProtocols()));
        properties.setRootSquash(sharePropertiesInternal.getRootSquash());
        properties.setMetadata(sharePropertiesInternal.getMetadata());
        return properties;
    }

    public static ShareProtocols parseShareProtocols(String str) {
        if (str == null) {
            return null;
        }
        ShareProtocols protocols = new ShareProtocols();
        String[] stringArray = str.split(",");
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String s;
            switch (s = stringArray[i]) {
                case "SMB": {
                    protocols.setSmbEnabled(true);
                    continue block8;
                }
                case "NFS": {
                    protocols.setNfsEnabled(true);
                    continue block8;
                }
            }
        }
        return protocols;
    }

    public static ServicesListSharesSegmentHeaders transformListSharesHeaders(HttpHeaders headers) {
        if (headers == null) {
            return null;
        }
        try {
            return (ServicesListSharesSegmentHeaders)SERIALIZER.deserialize(headers, ServicesListSharesSegmentHeaders.class);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    public static ShareFileDownloadHeaders transformFileDownloadHeaders(HttpHeaders headers) {
        if (headers == null) {
            return null;
        }
        try {
            return (ShareFileDownloadHeaders)SERIALIZER.deserialize(headers, ShareFileDownloadHeaders.class);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

