/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.LeaseDurationType;
import com.azure.storage.file.share.models.LeaseStateType;
import com.azure.storage.file.share.models.LeaseStatusType;
import com.azure.storage.file.share.models.ShareProtocols;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="ShareProperties")
public final class ShareProperties {
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String eTag;
    @JsonProperty(value="Quota", required=true)
    private int quota;
    @JsonProperty(value="ProvisionedIops")
    private Integer provisionedIops;
    @JsonProperty(value="ProvisionedIngressMBps")
    private Integer provisionedIngressMBps;
    @JsonProperty(value="ProvisionedEgressMBps")
    private Integer provisionedEgressMBps;
    @JsonProperty(value="NextAllowedQuotaDowngradeTime")
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;
    @JsonProperty(value="AccessTier")
    private String accessTier;
    @JsonProperty(value="AccessTierChangeTime")
    private DateTimeRfc1123 accessTierChangeTime;
    @JsonProperty(value="AccessTierTransitionState")
    private String accessTierTransitionState;
    @JsonProperty(value="LeaseStatus")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="LeaseState")
    private LeaseStateType leaseState;
    @JsonProperty(value="LeaseDuration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="EnabledProtocols")
    private ShareProtocols protocols;
    @JsonProperty(value="RootSquash")
    private ShareRootSquash rootSquash;
    @JsonProperty(value="Metadata")
    private Map<String, String> metadata;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ShareProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ShareProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public int getQuota() {
        return this.quota;
    }

    public ShareProperties setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    public ShareProperties setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    public ShareProperties setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    public ShareProperties setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    public ShareProperties setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        this.nextAllowedQuotaDowngradeTime = nextAllowedQuotaDowngradeTime == null ? null : new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public ShareProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public String getAccessTier() {
        return this.accessTier;
    }

    public ShareProperties setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public ShareProperties setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    public ShareProperties setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public ShareProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public ShareProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public ShareProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public ShareProtocols getProtocols() {
        return this.protocols;
    }

    public ShareProperties setProtocols(ShareProtocols protocols) {
        this.protocols = protocols;
        return this;
    }

    public ShareRootSquash getRootSquash() {
        return this.rootSquash;
    }

    public ShareProperties setRootSquash(ShareRootSquash rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

