/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.azure.storage.file.share.sas.ShareSasPermission;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ShareSasImplUtil {
    private static final String SAS_FILE_CONSTANT = "f";
    private static final String SAS_SHARE_CONSTANT = "s";
    private static final ClientLogger LOGGER = new ClientLogger(ShareSasImplUtil.class);
    private static final String VERSION = (String)Configuration.getGlobalConfiguration().get("AZURE_STORAGE_SAS_SERVICE_VERSION", (Object)ShareServiceVersion.getLatest().getVersion());
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String shareName;
    private String filePath;
    private String resource;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName) {
        this(sasValues, shareName, null);
    }

    public ShareSasImplUtil(ShareServiceSasSignatureValues sasValues, String shareName, String filePath) {
        Objects.requireNonNull(sasValues);
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.shareName = shareName;
        this.filePath = filePath;
        this.identifier = sasValues.getIdentifier();
        this.cacheControl = sasValues.getCacheControl();
        this.contentDisposition = sasValues.getContentDisposition();
        this.contentEncoding = sasValues.getContentEncoding();
        this.contentLanguage = sasValues.getContentLanguage();
        this.contentType = sasValues.getContentType();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String stringToSign = this.stringToSign(canonicalName);
        StorageImplUtils.logStringToSign((ClientLogger)LOGGER, (String)stringToSign, (Context)context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return this.encode(signature);
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sv", (Object)VERSION);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"st", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.startTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"se", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.expiryTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sip", (Object)this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"si", (Object)this.identifier);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sr", (Object)this.resource);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sp", (Object)this.permissions);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sig", (Object)signature);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscc", (Object)this.cacheControl);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscd", (Object)this.contentDisposition);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsce", (Object)this.contentEncoding);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rscl", (Object)this.contentLanguage);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"rsct", (Object)this.contentType);
        return sb.toString();
    }

    private void ensureState() {
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        this.resource = CoreUtils.isNullOrEmpty((CharSequence)this.filePath) ? SAS_SHARE_CONSTANT : SAS_FILE_CONSTANT;
        if (this.permissions != null) {
            switch (this.resource) {
                case "f": {
                    this.permissions = ShareFileSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "s": {
                    this.permissions = ShareSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    LOGGER.info("Not re-parsing permissions. Resource type '{}' is unknown.", new Object[]{this.resource});
                }
            }
        }
    }

    private String getCanonicalName(String account) {
        return !CoreUtils.isNullOrEmpty((CharSequence)this.filePath) ? String.format("/file/%s/%s/%s", account, this.shareName, this.filePath.replace("\\", "/")) : String.format("/file/%s/%s", account, this.shareName);
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION == null ? "" : VERSION, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

