/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.DirectoriesImpl;
import com.azure.storage.file.share.implementation.FilesImpl;
import com.azure.storage.file.share.implementation.ServicesImpl;
import com.azure.storage.file.share.implementation.SharesImpl;

public final class AzureFileStorageImpl {
    private final String version;
    private final String url;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final ServicesImpl services;
    private final SharesImpl shares;
    private final DirectoriesImpl directories;
    private final FilesImpl files;

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public ServicesImpl getServices() {
        return this.services;
    }

    public SharesImpl getShares() {
        return this.shares;
    }

    public DirectoriesImpl getDirectories() {
        return this.directories;
    }

    public FilesImpl getFiles() {
        return this.files;
    }

    AzureFileStorageImpl(String version, String url) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), version, url);
    }

    AzureFileStorageImpl(HttpPipeline httpPipeline, String version, String url) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), version, url);
    }

    AzureFileStorageImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String version, String url) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.version = version;
        this.url = url;
        this.services = new ServicesImpl(this);
        this.shares = new SharesImpl(this);
        this.directories = new DirectoriesImpl(this);
        this.files = new FilesImpl(this);
    }
}

