/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.util;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.storage.common.policy.MetadataValidationPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RequestRetryPolicy;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.file.share.implementation.util.FileHeadersAndQueryParameters;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class BuilderHelper {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-storage-file-share.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    private static final Pattern IP_URL_PATTERN = Pattern.compile("(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})|(?:localhost)");

    public static HttpPipeline buildPipeline(Supplier<HttpPipelinePolicy> credentialPolicySupplier, RequestRetryOptions retryOptions, HttpLogOptions logOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> perCallPolicies, List<HttpPipelinePolicy> perRetryPolicies, Configuration configuration) {
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(BuilderHelper.getUserAgentPolicy(configuration, logOptions, clientOptions));
        policies.add(new RequestIdPolicy());
        policies.addAll(perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(new RequestRetryPolicy(retryOptions));
        policies.add(new AddDatePolicy());
        HttpHeaders headers = new HttpHeaders();
        clientOptions.getHeaders().forEach(header -> headers.put(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.add(new MetadataValidationPolicy());
        HttpPipelinePolicy credentialPolicy = credentialPolicySupplier.get();
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    private static UserAgentPolicy getUserAgentPolicy(Configuration configuration, HttpLogOptions logOptions, ClientOptions clientOptions) {
        configuration = configuration == null ? Configuration.NONE : configuration;
        String applicationId = clientOptions.getApplicationId() != null ? clientOptions.getApplicationId() : logOptions.getApplicationId();
        return new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, configuration);
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        HttpLogOptions defaultOptions = new HttpLogOptions();
        FileHeadersAndQueryParameters.getFileHeaders().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedHeaderName(arg_0));
        FileHeadersAndQueryParameters.getFileQueryParameters().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedQueryParamName(arg_0));
        return defaultOptions;
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").build();
    }

    public static String getAccountName(URL url) {
        if (IP_URL_PATTERN.matcher(url.getHost()).find()) {
            String[] pathPieces;
            String path = url.getPath();
            if (!CoreUtils.isNullOrEmpty((CharSequence)path) && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            return (pathPieces = path.split("/", 1)).length == 1 ? pathPieces[0] : null;
        }
        String host = url.getHost();
        if (CoreUtils.isNullOrEmpty((CharSequence)host)) {
            return null;
        }
        int accountNameIndex = host.indexOf(46);
        if (accountNameIndex == -1) {
            return host;
        }
        return host.substring(0, accountNameIndex);
    }
}

