/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareDirectoryAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.ShareDirectoryInfo;
import com.azure.storage.file.share.models.ShareDirectoryProperties;
import com.azure.storage.file.share.models.ShareDirectorySetMetadataInfo;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.options.ShareListFilesAndDirectoriesOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareFileClientBuilder.class)
public class ShareDirectoryClient {
    private final ShareDirectoryAsyncClient shareDirectoryAsyncClient;

    ShareDirectoryClient(ShareDirectoryAsyncClient shareDirectoryAsyncClient) {
        this.shareDirectoryAsyncClient = shareDirectoryAsyncClient;
    }

    public String getDirectoryUrl() {
        return this.shareDirectoryAsyncClient.getDirectoryUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.shareDirectoryAsyncClient.getServiceVersion();
    }

    public ShareFileClient getFileClient(String fileName) {
        return new ShareFileClient(this.shareDirectoryAsyncClient.getFileClient(fileName));
    }

    public ShareDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        return new ShareDirectoryClient(this.shareDirectoryAsyncClient.getSubdirectoryClient(subdirectoryName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.shareDirectoryAsyncClient.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryInfo create() {
        return (ShareDirectoryInfo)this.createWithResponse(null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> createWithResponse(FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<ShareDirectoryInfo>> response = this.shareDirectoryAsyncClient.createWithResponse(smbProperties, filePermission, metadata, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareDirectoryAsyncClient.deleteWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryProperties getProperties() {
        return (ShareDirectoryProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<ShareDirectoryProperties>> response = this.shareDirectoryAsyncClient.getPropertiesWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryInfo setProperties(FileSmbProperties smbProperties, String filePermission) {
        return (ShareDirectoryInfo)this.setPropertiesWithResponse(smbProperties, filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryInfo> setPropertiesWithResponse(FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        Mono<Response<ShareDirectoryInfo>> response = this.shareDirectoryAsyncClient.setPropertiesWithResponse(smbProperties, filePermission, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectorySetMetadataInfo setMetadata(Map<String, String> metadata) {
        return (ShareDirectorySetMetadataInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectorySetMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Mono<Response<ShareDirectorySetMetadataInfo>> response = this.shareDirectoryAsyncClient.setMetadataWithResponse(metadata, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories() {
        return this.listFilesAndDirectories(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories(String prefix, Integer maxResultsPerPage, Duration timeout, Context context) {
        return this.listFilesAndDirectories(new ShareListFilesAndDirectoriesOptions().setPrefix(prefix).setMaxResultsPerPage(maxResultsPerPage), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileItem> listFilesAndDirectories(ShareListFilesAndDirectoriesOptions options, Duration timeout, Context context) {
        return new PagedIterable(this.shareDirectoryAsyncClient.listFilesAndDirectoriesWithOptionalTimeout(options, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, boolean recursive, Duration timeout, Context context) {
        return new PagedIterable(this.shareDirectoryAsyncClient.listHandlesWithOptionalTimeout(maxResultsPerPage, recursive, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return (CloseHandlesInfo)this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Mono<Response<CloseHandlesInfo>> response = this.shareDirectoryAsyncClient.forceCloseHandleWithResponse(handleId, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseAllHandles(boolean recursive, Duration timeout, Context context) {
        return new PagedIterable(this.shareDirectoryAsyncClient.forceCloseAllHandlesWithTimeout(recursive, timeout, context)).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareDirectoryClient createSubdirectory(String subdirectoryName) {
        return (ShareDirectoryClient)this.createSubdirectoryWithResponse(subdirectoryName, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        ShareDirectoryClient shareDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return new SimpleResponse(shareDirectoryClient.createWithResponse(smbProperties, filePermission, metadata, timeout, context), (Object)shareDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareDirectoryAsyncClient.deleteSubdirectoryWithResponse(subdirectoryName, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient createFile(String fileName, long maxSize) {
        return (ShareFileClient)this.createFileWithResponse(fileName, maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createFileWithResponse(fileName, maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> createFileWithResponse(String fileName, long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        ShareFileClient shareFileClient = this.getFileClient(fileName);
        Response<ShareFileInfo> response = shareFileClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, timeout, context);
        return new SimpleResponse(response, (Object)shareFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, Duration timeout, Context context) {
        return this.deleteFileWithResponse(fileName, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareDirectoryAsyncClient.deleteFileWithResponse(fileName, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String getShareSnapshotId() {
        return this.shareDirectoryAsyncClient.getShareSnapshotId();
    }

    public String getShareName() {
        return this.shareDirectoryAsyncClient.getShareName();
    }

    public String getDirectoryPath() {
        return this.shareDirectoryAsyncClient.getDirectoryPath();
    }

    public String getAccountName() {
        return this.shareDirectoryAsyncClient.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.shareDirectoryAsyncClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.shareDirectoryAsyncClient.generateSas(shareServiceSasSignatureValues);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.shareDirectoryAsyncClient.generateSas(shareServiceSasSignatureValues, context);
    }
}

