/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DirectoriesImpl {
    private final DirectoriesService service;
    private final AzureFileStorageImpl client;

    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesCreateResponse> createWithResponseAsync(String shareName, String directory, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, directory, "directory", timeout, metadata, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesGetPropertiesResponse> getPropertiesWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, directory, "directory", sharesnapshot, timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesDeleteResponse> deleteWithResponseAsync(String shareName, String directory, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, directory, "directory", timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesSetPropertiesResponse> setPropertiesWithResponseAsync(String shareName, String directory, String fileAttributes, String fileCreationTime, String fileLastWriteTime, Integer timeout, String filePermission, String filePermissionKey, Context context) {
        String restype = "directory";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesSetMetadataResponse> setMetadataWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        String restype = "directory";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listFilesAndDirectoriesSegment(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesListHandlesResponse> listHandlesWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandlesWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageDire")
    public static interface DirectoriesService {
        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesCreateResponse> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegment(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesListHandlesResponse> listHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);
    }
}

