// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;

/** An enumeration of shares. */
@JacksonXmlRootElement(localName = "EnumerationResults")
@Fluent
public final class ListSharesResponse {
    /*
     * The ServiceEndpoint property.
     */
    @JacksonXmlProperty(localName = "ServiceEndpoint", isAttribute = true)
    private String serviceEndpoint;

    /*
     * The Prefix property.
     */
    @JsonProperty(value = "Prefix")
    private String prefix;

    /*
     * The Marker property.
     */
    @JsonProperty(value = "Marker")
    private String marker;

    /*
     * The MaxResults property.
     */
    @JsonProperty(value = "MaxResults")
    private Integer maxResults;

    private static final class SharesWrapper {
        @JacksonXmlProperty(localName = "Share")
        private final List<ShareItemInternal> items;

        @JsonCreator
        private SharesWrapper(@JacksonXmlProperty(localName = "Share") List<ShareItemInternal> items) {
            this.items = items;
        }
    }

    /*
     * The ShareItems property.
     */
    @JsonProperty(value = "Shares")
    private SharesWrapper shareItems;

    /*
     * The NextMarker property.
     */
    @JsonProperty(value = "NextMarker", required = true)
    private String nextMarker;

    /**
     * Get the serviceEndpoint property: The ServiceEndpoint property.
     *
     * @return the serviceEndpoint value.
     */
    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint property: The ServiceEndpoint property.
     *
     * @param serviceEndpoint the serviceEndpoint value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the prefix property: The Prefix property.
     *
     * @return the prefix value.
     */
    public String getPrefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: The Prefix property.
     *
     * @param prefix the prefix value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the marker property: The Marker property.
     *
     * @return the marker value.
     */
    public String getMarker() {
        return this.marker;
    }

    /**
     * Set the marker property: The Marker property.
     *
     * @param marker the marker value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    /**
     * Get the maxResults property: The MaxResults property.
     *
     * @return the maxResults value.
     */
    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * Set the maxResults property: The MaxResults property.
     *
     * @param maxResults the maxResults value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Get the shareItems property: The ShareItems property.
     *
     * @return the shareItems value.
     */
    public List<ShareItemInternal> getShareItems() {
        if (this.shareItems == null) {
            this.shareItems = new SharesWrapper(new ArrayList<ShareItemInternal>());
        }
        return this.shareItems.items;
    }

    /**
     * Set the shareItems property: The ShareItems property.
     *
     * @param shareItems the shareItems value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setShareItems(List<ShareItemInternal> shareItems) {
        this.shareItems = new SharesWrapper(shareItems);
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     *
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the ListSharesResponse object itself.
     */
    public ListSharesResponse setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }
}
