/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import com.azure.storage.common.sas.CommonSasQueryParameters;
import com.azure.storage.file.share.ShareDirectoryAsyncClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.AzureFileStorageImplBuilder;
import com.azure.storage.file.share.implementation.util.BuilderHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ShareFileClient.class, ShareFileAsyncClient.class, ShareDirectoryClient.class, ShareDirectoryAsyncClient.class})
public class ShareFileClientBuilder
implements HttpTrait<ShareFileClientBuilder>,
ConnectionStringTrait<ShareFileClientBuilder>,
AzureNamedKeyCredentialTrait<ShareFileClientBuilder>,
AzureSasCredentialTrait<ShareFileClientBuilder>,
ConfigurationTrait<ShareFileClientBuilder>,
EndpointTrait<ShareFileClientBuilder> {
    private final ClientLogger logger = new ClientLogger(ShareFileClientBuilder.class);
    private String endpoint;
    private String accountName;
    private String shareName;
    private String shareSnapshot;
    private String resourcePath;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private ShareServiceVersion version;

    public ShareFileClientBuilder() {
        this.logOptions = ShareFileClientBuilder.getDefaultHttpLogOptions();
    }

    private ShareServiceVersion getServiceVersion() {
        return this.version != null ? this.version : ShareServiceVersion.getLatest();
    }

    private AzureFileStorageImpl constructImpl(ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(this.shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(this.resourcePath, "'resourcePath' cannot be null.");
        CredentialValidator.validateSingleCredentialIsPresent((StorageSharedKeyCredential)this.storageSharedKeyCredential, null, (AzureSasCredential)this.azureSasCredential, (String)this.sasToken, (ClientLogger)this.logger);
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(() -> {
            if (this.storageSharedKeyCredential != null) {
                return new StorageSharedKeyCredentialPolicy(this.storageSharedKeyCredential);
            }
            if (this.azureSasCredential != null) {
                return new AzureSasCredentialPolicy(this.azureSasCredential, false);
            }
            if (this.sasToken != null) {
                return new AzureSasCredentialPolicy(new AzureSasCredential(this.sasToken), false);
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials are required for authorization"));
        }, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger);
        return new AzureFileStorageImplBuilder().url(this.endpoint).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
    }

    public ShareDirectoryAsyncClient buildDirectoryAsyncClient() {
        ShareServiceVersion serviceVersion = this.getServiceVersion();
        return new ShareDirectoryAsyncClient(this.constructImpl(serviceVersion), this.shareName, this.resourcePath, this.shareSnapshot, this.accountName, serviceVersion);
    }

    public ShareDirectoryClient buildDirectoryClient() {
        return new ShareDirectoryClient(this.buildDirectoryAsyncClient());
    }

    public ShareFileAsyncClient buildFileAsyncClient() {
        ShareServiceVersion serviceVersion = this.getServiceVersion();
        return new ShareFileAsyncClient(this.constructImpl(serviceVersion), this.shareName, this.resourcePath, this.shareSnapshot, this.accountName, serviceVersion);
    }

    public ShareFileClient buildFileClient() {
        return new ShareFileClient(this.buildFileAsyncClient());
    }

    public ShareFileClientBuilder endpoint(String endpoint) {
        try {
            String sasToken;
            URL fullUrl = new URL(endpoint);
            this.endpoint = fullUrl.getProtocol() + "://" + fullUrl.getHost();
            this.accountName = BuilderHelper.getAccountName(fullUrl);
            String[] pathSegments = fullUrl.getPath().split("/");
            int length = pathSegments.length;
            this.shareName = length >= 2 ? pathSegments[1] : this.shareName;
            CharSequence[] filePathParams = length >= 3 ? Arrays.copyOfRange(pathSegments, 2, length) : null;
            this.resourcePath = filePathParams != null ? String.join((CharSequence)"/", filePathParams) : this.resourcePath;
            Map queryParamsMap = SasImplUtils.parseQueryString((String)fullUrl.getQuery());
            String[] snapshotArray = (String[])queryParamsMap.remove("sharesnapshot");
            if (snapshotArray != null) {
                this.shareSnapshot = snapshotArray[0];
            }
            if (!CoreUtils.isNullOrEmpty((CharSequence)(sasToken = new CommonSasQueryParameters(SasImplUtils.parseQueryString((String)fullUrl.getQuery()), false).encode()))) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage File endpoint url is malformed.", ex));
        }
        return this;
    }

    public ShareFileClientBuilder shareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    public ShareFileClientBuilder snapshot(String snapshot) {
        this.shareSnapshot = snapshot;
        return this;
    }

    public ShareFileClientBuilder resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public ShareFileClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.sasToken = null;
        return this;
    }

    public ShareFileClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential((AzureNamedKeyCredential)credential));
    }

    public ShareFileClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        return this;
    }

    public ShareFileClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public ShareFileClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)this.logger);
        StorageEndpoint endpoint = storageConnectionString.getFileEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive file service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public ShareFileClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public ShareFileClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public ShareFileClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public ShareFileClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ShareFileClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ShareFileClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    public ShareFileClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ShareFileClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public ShareFileClientBuilder serviceVersion(ShareServiceVersion version) {
        this.version = version;
        return this;
    }
}

