// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesRenameResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in Directories. */
public final class DirectoriesImpl {
    /** The proxy service used to perform REST calls. */
    private final DirectoriesService service;

    /** The service client containing this operation class. */
    private final AzureFileStorageImpl client;

    /**
     * Initializes an instance of DirectoriesImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service =
                RestProxy.create(DirectoriesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureFileStorageDirectories to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureFileStorageDire")
    public interface DirectoriesService {
        @Put("/{shareName}/{directory}")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesCreateResponse> create(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-file-permission") String filePermission,
                @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
                @HeaderParam("x-ms-file-attributes") String fileAttributes,
                @HeaderParam("x-ms-file-creation-time") String fileCreationTime,
                @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime,
                @HeaderParam("x-ms-file-change-time") String fileChangeTime,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesGetPropertiesResponse> getProperties(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/{shareName}/{directory}")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesDeleteResponse> delete(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesSetPropertiesResponse> setProperties(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-file-permission") String filePermission,
                @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
                @HeaderParam("x-ms-file-attributes") String fileAttributes,
                @HeaderParam("x-ms-file-creation-time") String fileCreationTime,
                @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime,
                @HeaderParam("x-ms-file-change-time") String fileChangeTime,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesSetMetadataResponse> setMetadata(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegment(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @QueryParam("prefix") String prefix,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @QueryParam("marker") String marker,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @QueryParam("include") String include,
                @HeaderParam("x-ms-file-extended-info") Boolean includeExtendedInfo,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesListHandlesResponse> listHandles(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("comp") String comp,
                @QueryParam("marker") String marker,
                @QueryParam("maxresults") Integer maxresults,
                @QueryParam("timeout") Integer timeout,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @HeaderParam("x-ms-recursive") Boolean recursive,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandles(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @QueryParam("marker") String marker,
                @QueryParam("sharesnapshot") String sharesnapshot,
                @HeaderParam("x-ms-handle-id") String handleId,
                @HeaderParam("x-ms-recursive") Boolean recursive,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("Accept") String accept,
                Context context);

        @Put("/{shareName}/{directory}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ShareStorageException.class)
        Mono<DirectoriesRenameResponse> rename(
                @HostParam("url") String url,
                @PathParam("shareName") String shareName,
                @PathParam("directory") String directory,
                @QueryParam("restype") String restype,
                @QueryParam("comp") String comp,
                @QueryParam("timeout") Integer timeout,
                @HeaderParam("x-ms-version") String version,
                @HeaderParam("x-ms-file-rename-source") String renameSource,
                @HeaderParam("x-ms-file-rename-replace-if-exists") Boolean replaceIfExists,
                @HeaderParam("x-ms-file-rename-ignore-readonly") Boolean ignoreReadOnly,
                @HeaderParam("x-ms-source-lease-id") String sourceLeaseId,
                @HeaderParam("x-ms-destination-lease-id") String destinationLeaseId,
                @HeaderParam("x-ms-file-attributes") String fileAttributes,
                @HeaderParam("x-ms-file-creation-time") String fileCreationTime,
                @HeaderParam("x-ms-file-last-write-time") String fileLastWriteTime,
                @HeaderParam("x-ms-file-change-time") String fileChangeTime,
                @HeaderParam("x-ms-file-permission") String filePermission,
                @HeaderParam("x-ms-file-permission-key") String filePermissionKey,
                @HeaderParam("x-ms-meta-") Map<String, String> metadata,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Creates a new directory under the specified share or parent directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file
     *     and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This
     *     header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used.
     *     Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of
     *     the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the
     *     x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param fileChangeTime Change time for the file/directory. Default value: Now.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesCreateResponse> createWithResponseAsync(
            String shareName,
            String directory,
            String fileAttributes,
            Integer timeout,
            Map<String, String> metadata,
            String filePermission,
            String filePermissionKey,
            String fileCreationTime,
            String fileLastWriteTime,
            String fileChangeTime,
            Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.create(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                timeout,
                metadata,
                this.client.getVersion(),
                filePermission,
                filePermissionKey,
                fileAttributes,
                fileCreationTime,
                fileLastWriteTime,
                fileChangeTime,
                accept,
                context);
    }

    /**
     * Returns all system properties for the specified directory, and can also be used to check the existence of a
     * directory. The data returned does not include the files in the directory or any subdirectories.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesGetPropertiesResponse> getPropertiesWithResponseAsync(
            String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.getProperties(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                sharesnapshot,
                timeout,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Removes the specified empty directory. Note that the directory must be empty before it can be deleted.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesDeleteResponse> deleteWithResponseAsync(
            String shareName, String directory, Integer timeout, Context context) {
        final String restype = "directory";
        final String accept = "application/xml";
        return service.delete(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                timeout,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Sets properties on the directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param fileAttributes If specified, the provided file attributes shall be set. Default value: ‘Archive’ for file
     *     and ‘Directory’ for directory. ‘None’ can also be specified as default.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This
     *     header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used.
     *     Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of
     *     the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the
     *     x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param fileCreationTime Creation time for the file/directory. Default value: Now.
     * @param fileLastWriteTime Last write time for the file/directory. Default value: Now.
     * @param fileChangeTime Change time for the file/directory. Default value: Now.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesSetPropertiesResponse> setPropertiesWithResponseAsync(
            String shareName,
            String directory,
            String fileAttributes,
            Integer timeout,
            String filePermission,
            String filePermissionKey,
            String fileCreationTime,
            String fileLastWriteTime,
            String fileChangeTime,
            Context context) {
        final String restype = "directory";
        final String comp = "properties";
        final String accept = "application/xml";
        return service.setProperties(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                comp,
                timeout,
                this.client.getVersion(),
                filePermission,
                filePermissionKey,
                fileAttributes,
                fileCreationTime,
                fileLastWriteTime,
                fileChangeTime,
                accept,
                context);
    }

    /**
     * Updates user defined metadata for the specified directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesSetMetadataResponse> setMetadataWithResponseAsync(
            String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        final String restype = "directory";
        final String comp = "metadata";
        final String accept = "application/xml";
        return service.setMetadata(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                comp,
                timeout,
                metadata,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Returns a list of files or directories under the specified share or directory. It lists the contents only for a
     * single level of the directory hierarchy.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param prefix Filters the results to return only entries whose name begins with the specified prefix.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     *     or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param include Include this parameter to specify one or more datasets to include in the response.
     * @param includeExtendedInfo Include extended information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of directories and files on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesListFilesAndDirectoriesSegmentResponse> listFilesAndDirectoriesSegmentWithResponseAsync(
            String shareName,
            String directory,
            String prefix,
            String sharesnapshot,
            String marker,
            Integer maxresults,
            Integer timeout,
            List<ListFilesIncludeType> include,
            Boolean includeExtendedInfo,
            Context context) {
        final String restype = "directory";
        final String comp = "list";
        final String accept = "application/xml";
        String includeConverted =
                JacksonAdapter.createDefaultSerializerAdapter().serializeList(include, CollectionFormat.CSV);
        return service.listFilesAndDirectoriesSegment(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                comp,
                prefix,
                sharesnapshot,
                marker,
                maxresults,
                timeout,
                this.client.getVersion(),
                includeConverted,
                includeExtendedInfo,
                accept,
                context);
    }

    /**
     * Lists handles for directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param maxresults Specifies the maximum number of entries to return. If the request does not specify maxresults,
     *     or specifies a value greater than 5,000, the server will return up to 5,000 items.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param recursive Specifies operation should apply to the directory specified in the URI, its files, its
     *     subdirectories and their files.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an enumeration of handles on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesListHandlesResponse> listHandlesWithResponseAsync(
            String shareName,
            String directory,
            String marker,
            Integer maxresults,
            Integer timeout,
            String sharesnapshot,
            Boolean recursive,
            Context context) {
        final String comp = "listhandles";
        final String accept = "application/xml";
        return service.listHandles(
                this.client.getUrl(),
                shareName,
                directory,
                comp,
                marker,
                maxresults,
                timeout,
                sharesnapshot,
                recursive,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Closes all handles open for given directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is a wildcard
     *     that specifies all handles.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param marker A string value that identifies the portion of the list to be returned with the next list operation.
     *     The operation returns a marker value within the response body if the list returned was not complete. The
     *     marker value may then be used in a subsequent call to request the next set of list items. The marker value is
     *     opaque to the client.
     * @param sharesnapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the share
     *     snapshot to query.
     * @param recursive Specifies operation should apply to the directory specified in the URI, its files, its
     *     subdirectories and their files.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesForceCloseHandlesResponse> forceCloseHandlesWithResponseAsync(
            String shareName,
            String directory,
            String handleId,
            Integer timeout,
            String marker,
            String sharesnapshot,
            Boolean recursive,
            Context context) {
        final String comp = "forceclosehandles";
        final String accept = "application/xml";
        return service.forceCloseHandles(
                this.client.getUrl(),
                shareName,
                directory,
                comp,
                timeout,
                marker,
                sharesnapshot,
                handleId,
                recursive,
                this.client.getVersion(),
                accept,
                context);
    }

    /**
     * Renames a directory.
     *
     * @param shareName The name of the target share.
     * @param directory The path of the target directory.
     * @param renameSource Required. Specifies the URI-style path of the source file, up to 2 KB in length.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     *     href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN"&gt;Setting
     *     Timeouts for File Service Operations.&lt;/a&gt;.
     * @param replaceIfExists Optional. A boolean value for if the destination file already exists, whether this request
     *     will overwrite the file or not. If true, the rename will succeed and will overwrite the destination file. If
     *     not provided or if false and the destination file does exist, the request will not overwrite the destination
     *     file. If provided and the destination file doesn’t exist, the rename will succeed. Note: This value does not
     *     override the x-ms-file-copy-ignore-read-only header value.
     * @param ignoreReadOnly Optional. A boolean value that specifies whether the ReadOnly attribute on a preexisting
     *     destination file should be respected. If true, the rename will succeed, otherwise, a previous file at the
     *     destination with the ReadOnly attribute set will cause the rename to fail.
     * @param filePermission If specified the permission (security descriptor) shall be set for the directory/file. This
     *     header can be used if Permission size is &lt;= 8KB, else x-ms-file-permission-key header shall be used.
     *     Default value: Inherit. If SDDL is specified as input, it must have owner, group and dacl. Note: Only one of
     *     the x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param filePermissionKey Key of the permission to be set for the directory/file. Note: Only one of the
     *     x-ms-file-permission or x-ms-file-permission-key should be specified.
     * @param metadata A name-value pair to associate with a file storage object.
     * @param sourceLeaseAccessConditions Parameter group.
     * @param destinationLeaseAccessConditions Parameter group.
     * @param copyFileSmbInfo Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ShareStorageException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DirectoriesRenameResponse> renameWithResponseAsync(
            String shareName,
            String directory,
            String renameSource,
            Integer timeout,
            Boolean replaceIfExists,
            Boolean ignoreReadOnly,
            String filePermission,
            String filePermissionKey,
            Map<String, String> metadata,
            SourceLeaseAccessConditions sourceLeaseAccessConditions,
            DestinationLeaseAccessConditions destinationLeaseAccessConditions,
            CopyFileSmbInfo copyFileSmbInfo,
            Context context) {
        final String restype = "directory";
        final String comp = "rename";
        final String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        return service.rename(
                this.client.getUrl(),
                shareName,
                directory,
                restype,
                comp,
                timeout,
                this.client.getVersion(),
                renameSource,
                replaceIfExists,
                ignoreReadOnly,
                sourceLeaseId,
                destinationLeaseId,
                fileAttributes,
                fileCreationTime,
                fileLastWriteTime,
                fileChangeTime,
                filePermission,
                filePermissionKey,
                metadata,
                accept,
                context);
    }
}
