/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.FilesAbortCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesAcquireLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesBreakLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesChangeLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesCreateResponse;
import com.azure.storage.file.share.implementation.models.FilesDeleteResponse;
import com.azure.storage.file.share.implementation.models.FilesForceCloseHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetPropertiesResponse;
import com.azure.storage.file.share.implementation.models.FilesGetRangeListResponse;
import com.azure.storage.file.share.implementation.models.FilesListHandlesResponse;
import com.azure.storage.file.share.implementation.models.FilesReleaseLeaseResponse;
import com.azure.storage.file.share.implementation.models.FilesRenameResponse;
import com.azure.storage.file.share.implementation.models.FilesSetHttpHeadersResponse;
import com.azure.storage.file.share.implementation.models.FilesSetMetadataResponse;
import com.azure.storage.file.share.implementation.models.FilesStartCopyResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeFromURLResponse;
import com.azure.storage.file.share.implementation.models.FilesUploadRangeResponse;
import com.azure.storage.file.share.implementation.models.ShareFileRangeWriteType;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.models.FileLastWrittenMode;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareStorageException;
import com.azure.storage.file.share.models.SourceModifiedAccessConditions;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FilesImpl {
    private final FilesService service;
    private final AzureFileStorageImpl client;

    FilesImpl(AzureFileStorageImpl client) {
        this.service = (FilesService)RestProxy.create(FilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesCreateResponse> createWithResponseAsync(String shareName, String fileName, long fileContentLength, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String fileTypeConstant = "file";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.create(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), fileContentLength, "file", contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, metadata, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> downloadWithResponseAsync(String shareName, String fileName, Integer timeout, String range, Boolean rangeGetContentMD5, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.download(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), range, rangeGetContentMD5, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesGetPropertiesResponse> getPropertiesWithResponseAsync(String shareName, String fileName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, fileName, sharesnapshot, timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesDeleteResponse> deleteWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesSetHttpHeadersResponse> setHttpHeadersWithResponseAsync(String shareName, String fileName, String fileAttributes, Integer timeout, Long fileContentLength, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, String leaseId, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "properties";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (shareFileHttpHeaders != null) {
            contentEncodingInternal = shareFileHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (shareFileHttpHeaders != null) {
            contentLanguageInternal = shareFileHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        String cacheControlInternal = null;
        if (shareFileHttpHeaders != null) {
            cacheControlInternal = shareFileHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        byte[] contentMd5Internal = null;
        if (shareFileHttpHeaders != null) {
            contentMd5Internal = shareFileHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (shareFileHttpHeaders != null) {
            contentDispositionInternal = shareFileHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.setHttpHeaders(this.client.getUrl(), shareName, fileName, "properties", timeout, this.client.getVersion(), fileContentLength, contentType, contentEncoding, contentLanguage, cacheControl, contentMd5Converted, contentDisposition, filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesUploadRangeResponse> uploadRangeWithResponseAsync(String shareName, String fileName, String range, ShareFileRangeWriteType fileRangeWrite, long contentLength, Integer timeout, byte[] contentMD5, String leaseId, FileLastWrittenMode fileLastWrittenMode, Flux<ByteBuffer> optionalbody, Context context) {
        String comp = "range";
        String accept = "application/xml";
        String contentMD5Converted = Base64Util.encodeToString((byte[])contentMD5);
        return this.service.uploadRange(this.client.getUrl(), shareName, fileName, "range", timeout, range, fileRangeWrite, contentLength, contentMD5Converted, this.client.getVersion(), leaseId, fileLastWrittenMode, optionalbody, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesSetMetadataResponse> setMetadataWithResponseAsync(String shareName, String fileName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, fileName, "metadata", timeout, metadata, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesAcquireLeaseResponse> acquireLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, Integer duration, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String accept = "application/xml";
        return this.service.acquireLease(this.client.getUrl(), shareName, fileName, "lease", "acquire", timeout, duration, proposedLeaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesReleaseLeaseResponse> releaseLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String accept = "application/xml";
        return this.service.releaseLease(this.client.getUrl(), shareName, fileName, "lease", "release", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesChangeLeaseResponse> changeLeaseWithResponseAsync(String shareName, String fileName, String leaseId, Integer timeout, String proposedLeaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String accept = "application/xml";
        return this.service.changeLease(this.client.getUrl(), shareName, fileName, "lease", "change", timeout, leaseId, proposedLeaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesBreakLeaseResponse> breakLeaseWithResponseAsync(String shareName, String fileName, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        String accept = "application/xml";
        return this.service.breakLease(this.client.getUrl(), shareName, fileName, "lease", "break", timeout, leaseId, this.client.getVersion(), requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURLWithResponseAsync(String shareName, String fileName, String range, String copySource, long contentLength, Integer timeout, String sourceRange, byte[] sourceContentCrc64, String leaseId, String copySourceAuthorization, FileLastWrittenMode fileLastWrittenMode, SourceModifiedAccessConditions sourceModifiedAccessConditions, Context context) {
        String comp = "range";
        String fileRangeWriteFromUrl = "update";
        String accept = "application/xml";
        byte[] sourceIfMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfMatchCrc64();
        }
        byte[] sourceIfMatchCrc64 = sourceIfMatchCrc64Internal;
        byte[] sourceIfNoneMatchCrc64Internal = null;
        if (sourceModifiedAccessConditions != null) {
            sourceIfNoneMatchCrc64Internal = sourceModifiedAccessConditions.getSourceIfNoneMatchCrc64();
        }
        byte[] sourceIfNoneMatchCrc64 = sourceIfNoneMatchCrc64Internal;
        String sourceContentCrc64Converted = Base64Util.encodeToString((byte[])sourceContentCrc64);
        String sourceIfMatchCrc64Converted = Base64Util.encodeToString((byte[])sourceIfMatchCrc64);
        String sourceIfNoneMatchCrc64Converted = Base64Util.encodeToString((byte[])sourceIfNoneMatchCrc64);
        return this.service.uploadRangeFromURL(this.client.getUrl(), shareName, fileName, "range", timeout, range, copySource, sourceRange, "update", contentLength, sourceContentCrc64Converted, sourceIfMatchCrc64Converted, sourceIfNoneMatchCrc64Converted, this.client.getVersion(), leaseId, copySourceAuthorization, fileLastWrittenMode, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesGetRangeListResponse> getRangeListWithResponseAsync(String shareName, String fileName, String sharesnapshot, String prevsharesnapshot, Integer timeout, String range, String leaseId, Context context) {
        String comp = "rangelist";
        String accept = "application/xml";
        return this.service.getRangeList(this.client.getUrl(), shareName, fileName, "rangelist", sharesnapshot, prevsharesnapshot, timeout, this.client.getVersion(), range, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesStartCopyResponse> startCopyWithResponseAsync(String shareName, String fileName, String copySource, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String leaseId, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String accept = "application/xml";
        PermissionCopyModeType filePermissionCopyModeInternal = null;
        if (copyFileSmbInfo != null) {
            filePermissionCopyModeInternal = copyFileSmbInfo.getFilePermissionCopyMode();
        }
        PermissionCopyModeType filePermissionCopyMode = filePermissionCopyModeInternal;
        Boolean ignoreReadOnlyInternal = null;
        if (copyFileSmbInfo != null) {
            ignoreReadOnlyInternal = copyFileSmbInfo.isIgnoreReadOnly();
        }
        Boolean ignoreReadOnly = ignoreReadOnlyInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        Boolean setArchiveAttributeInternal = null;
        if (copyFileSmbInfo != null) {
            setArchiveAttributeInternal = copyFileSmbInfo.isSetArchiveAttribute();
        }
        Boolean setArchiveAttribute = setArchiveAttributeInternal;
        return this.service.startCopy(this.client.getUrl(), shareName, fileName, timeout, this.client.getVersion(), metadata, copySource, filePermission, filePermissionKey, filePermissionCopyMode, ignoreReadOnly, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, setArchiveAttribute, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesAbortCopyResponse> abortCopyWithResponseAsync(String shareName, String fileName, String copyId, Integer timeout, String leaseId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        String accept = "application/xml";
        return this.service.abortCopy(this.client.getUrl(), shareName, fileName, "copy", copyId, timeout, "abort", this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesListHandlesResponse> listHandlesWithResponseAsync(String shareName, String fileName, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), shareName, fileName, "listhandles", marker, maxresults, timeout, sharesnapshot, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesForceCloseHandlesResponse> forceCloseHandlesWithResponseAsync(String shareName, String fileName, String handleId, Integer timeout, String marker, String sharesnapshot, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), shareName, fileName, "forceclosehandles", timeout, marker, sharesnapshot, handleId, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FilesRenameResponse> renameWithResponseAsync(String shareName, String fileName, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, ShareFileHttpHeaders shareFileHttpHeaders, Context context) {
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        String contentTypeInternal = null;
        if (shareFileHttpHeaders != null) {
            contentTypeInternal = shareFileHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        return this.service.rename(this.client.getUrl(), shareName, fileName, "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, contentType, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageFile")
    public static interface FilesService {
        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesCreateResponse> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-content-length") long var6, @HeaderParam(value="x-ms-type") String var8, @HeaderParam(value="x-ms-content-type") String var9, @HeaderParam(value="x-ms-content-encoding") String var10, @HeaderParam(value="x-ms-content-language") String var11, @HeaderParam(value="x-ms-cache-control") String var12, @HeaderParam(value="x-ms-content-md5") String var13, @HeaderParam(value="x-ms-content-disposition") String var14, @HeaderParam(value="x-ms-meta-") Map<String, String> var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-file-attributes") String var18, @HeaderParam(value="x-ms-file-creation-time") String var19, @HeaderParam(value="x-ms-file-last-write-time") String var20, @HeaderParam(value="x-ms-file-change-time") String var21, @HeaderParam(value="x-ms-lease-id") String var22, @HeaderParam(value="Accept") String var23, Context var24);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<StreamResponse> download(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Head(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesDeleteResponse> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesSetHttpHeadersResponse> setHttpHeaders(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-content-length") Long var7, @HeaderParam(value="x-ms-content-type") String var8, @HeaderParam(value="x-ms-content-encoding") String var9, @HeaderParam(value="x-ms-content-language") String var10, @HeaderParam(value="x-ms-cache-control") String var11, @HeaderParam(value="x-ms-content-md5") String var12, @HeaderParam(value="x-ms-content-disposition") String var13, @HeaderParam(value="x-ms-file-permission") String var14, @HeaderParam(value="x-ms-file-permission-key") String var15, @HeaderParam(value="x-ms-file-attributes") String var16, @HeaderParam(value="x-ms-file-creation-time") String var17, @HeaderParam(value="x-ms-file-last-write-time") String var18, @HeaderParam(value="x-ms-file-change-time") String var19, @HeaderParam(value="x-ms-lease-id") String var20, @HeaderParam(value="Accept") String var21, Context var22);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesUploadRangeResponse> uploadRange(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-write") ShareFileRangeWriteType var7, @HeaderParam(value="Content-Length") long var8, @HeaderParam(value="Content-MD5") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-lease-id") String var12, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var13, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesAcquireLeaseResponse> acquireLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesReleaseLeaseResponse> releaseLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesChangeLeaseResponse> changeLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesBreakLeaseResponse> breakLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-lease-action") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesUploadRangeFromURLResponse> uploadRangeFromURL(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-source-range") String var8, @HeaderParam(value="x-ms-write") String var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="x-ms-source-content-crc64") String var12, @HeaderParam(value="x-ms-source-if-match-crc64") String var13, @HeaderParam(value="x-ms-source-if-none-match-crc64") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-lease-id") String var16, @HeaderParam(value="x-ms-copy-source-authorization") String var17, @HeaderParam(value="x-ms-file-last-write-time") FileLastWrittenMode var18, @HeaderParam(value="Accept") String var19, Context var20);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesGetRangeListResponse> getRangeList(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="prevsharesnapshot") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-range") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesStartCopyResponse> startCopy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-copy-source") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-permission-copy-mode") PermissionCopyModeType var10, @HeaderParam(value="x-ms-file-copy-ignore-readonly") Boolean var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-copy-set-archive") Boolean var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="Accept") String var18, Context var19);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesAbortCopyResponse> abortCopy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="copyid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-copy-action") String var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesListHandlesResponse> listHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesForceCloseHandlesResponse> forceCloseHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Put(value="/{shareName}/{fileName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<FilesRenameResponse> rename(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="fileName") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-file-rename-source") String var7, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var8, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var9, @HeaderParam(value="x-ms-source-lease-id") String var10, @HeaderParam(value="x-ms-destination-lease-id") String var11, @HeaderParam(value="x-ms-file-attributes") String var12, @HeaderParam(value="x-ms-file-creation-time") String var13, @HeaderParam(value="x-ms-file-last-write-time") String var14, @HeaderParam(value="x-ms-file-change-time") String var15, @HeaderParam(value="x-ms-file-permission") String var16, @HeaderParam(value="x-ms-file-permission-key") String var17, @HeaderParam(value="x-ms-meta-") Map<String, String> var18, @HeaderParam(value="x-ms-content-type") String var19, @HeaderParam(value="Accept") String var20, Context var21);
    }
}

