/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.CopyFileSmbInfo;
import com.azure.storage.file.share.implementation.models.DestinationLeaseAccessConditions;
import com.azure.storage.file.share.implementation.models.DirectoriesCreateHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesForceCloseHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListFilesAndDirectoriesSegmentHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesListHandlesHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesRenameHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.DirectoriesSetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.ListFilesAndDirectoriesSegmentResponse;
import com.azure.storage.file.share.implementation.models.ListFilesIncludeType;
import com.azure.storage.file.share.implementation.models.ListHandlesResponse;
import com.azure.storage.file.share.implementation.models.SourceLeaseAccessConditions;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DirectoriesImpl {
    private final DirectoriesService service;
    private final AzureFileStorageImpl client;

    DirectoriesImpl(AzureFileStorageImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesCreateHeaders, Void>> createWithResponseAsync(String shareName, String directory, String fileAttributes, Integer timeout, Map<String, String> metadata, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, directory, "directory", timeout, metadata, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String directory, String sharesnapshot, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, directory, "directory", sharesnapshot, timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String directory, Integer timeout, Context context) {
        String restype = "directory";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, directory, "directory", timeout, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, String directory, String fileAttributes, Integer timeout, String filePermission, String filePermissionKey, String fileCreationTime, String fileLastWriteTime, String fileChangeTime, Context context) {
        String restype = "directory";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, directory, "directory", "properties", timeout, this.client.getVersion(), filePermission, filePermissionKey, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, String directory, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "directory";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, directory, "directory", "metadata", timeout, metadata, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegmentWithResponseAsync(String shareName, String directory, String prefix, String sharesnapshot, String marker, Integer maxresults, Integer timeout, List<ListFilesIncludeType> include, Boolean includeExtendedInfo, Context context) {
        String restype = "directory";
        String comp = "list";
        String accept = "application/xml";
        String includeConverted = include == null ? null : include.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return this.service.listFilesAndDirectoriesSegment(this.client.getUrl(), shareName, directory, "directory", "list", prefix, sharesnapshot, marker, maxresults, timeout, this.client.getVersion(), includeConverted, includeExtendedInfo, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse>> listHandlesWithResponseAsync(String shareName, String directory, String marker, Integer maxresults, Integer timeout, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "listhandles";
        String accept = "application/xml";
        return this.service.listHandles(this.client.getUrl(), shareName, directory, "listhandles", marker, maxresults, timeout, sharesnapshot, recursive, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesForceCloseHandlesHeaders, Void>> forceCloseHandlesWithResponseAsync(String shareName, String directory, String handleId, Integer timeout, String marker, String sharesnapshot, Boolean recursive, Context context) {
        String comp = "forceclosehandles";
        String accept = "application/xml";
        return this.service.forceCloseHandles(this.client.getUrl(), shareName, directory, "forceclosehandles", timeout, marker, sharesnapshot, handleId, recursive, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<DirectoriesRenameHeaders, Void>> renameWithResponseAsync(String shareName, String directory, String renameSource, Integer timeout, Boolean replaceIfExists, Boolean ignoreReadOnly, String filePermission, String filePermissionKey, Map<String, String> metadata, SourceLeaseAccessConditions sourceLeaseAccessConditions, DestinationLeaseAccessConditions destinationLeaseAccessConditions, CopyFileSmbInfo copyFileSmbInfo, Context context) {
        String restype = "directory";
        String comp = "rename";
        String accept = "application/xml";
        String sourceLeaseIdInternal = null;
        if (sourceLeaseAccessConditions != null) {
            sourceLeaseIdInternal = sourceLeaseAccessConditions.getSourceLeaseId();
        }
        String sourceLeaseId = sourceLeaseIdInternal;
        String destinationLeaseIdInternal = null;
        if (destinationLeaseAccessConditions != null) {
            destinationLeaseIdInternal = destinationLeaseAccessConditions.getDestinationLeaseId();
        }
        String destinationLeaseId = destinationLeaseIdInternal;
        String fileAttributesInternal = null;
        if (copyFileSmbInfo != null) {
            fileAttributesInternal = copyFileSmbInfo.getFileAttributes();
        }
        String fileAttributes = fileAttributesInternal;
        String fileCreationTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileCreationTimeInternal = copyFileSmbInfo.getFileCreationTime();
        }
        String fileCreationTime = fileCreationTimeInternal;
        String fileLastWriteTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileLastWriteTimeInternal = copyFileSmbInfo.getFileLastWriteTime();
        }
        String fileLastWriteTime = fileLastWriteTimeInternal;
        String fileChangeTimeInternal = null;
        if (copyFileSmbInfo != null) {
            fileChangeTimeInternal = copyFileSmbInfo.getFileChangeTime();
        }
        String fileChangeTime = fileChangeTimeInternal;
        return this.service.rename(this.client.getUrl(), shareName, directory, "directory", "rename", timeout, this.client.getVersion(), renameSource, replaceIfExists, ignoreReadOnly, sourceLeaseId, destinationLeaseId, fileAttributes, fileCreationTime, fileLastWriteTime, fileChangeTime, filePermission, filePermissionKey, metadata, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageDire")
    public static interface DirectoriesService {
        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="x-ms-file-change-time") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="sharesnapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}/{directory}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-permission") String var8, @HeaderParam(value="x-ms-file-permission-key") String var9, @HeaderParam(value="x-ms-file-attributes") String var10, @HeaderParam(value="x-ms-file-creation-time") String var11, @HeaderParam(value="x-ms-file-last-write-time") String var12, @HeaderParam(value="x-ms-file-change-time") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-meta-") Map<String, String> var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesListFilesAndDirectoriesSegmentHeaders, ListFilesAndDirectoriesSegmentResponse>> listFilesAndDirectoriesSegment(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="prefix") String var6, @QueryParam(value="sharesnapshot") String var7, @QueryParam(value="marker") String var8, @QueryParam(value="maxresults") Integer var9, @QueryParam(value="timeout") Integer var10, @HeaderParam(value="x-ms-version") String var11, @QueryParam(value="include") String var12, @HeaderParam(value="x-ms-file-extended-info") Boolean var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Get(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesListHandlesHeaders, ListHandlesResponse>> listHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="marker") String var5, @QueryParam(value="maxresults") Integer var6, @QueryParam(value="timeout") Integer var7, @QueryParam(value="sharesnapshot") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesForceCloseHandlesHeaders, Void>> forceCloseHandles(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="marker") String var6, @QueryParam(value="sharesnapshot") String var7, @HeaderParam(value="x-ms-handle-id") String var8, @HeaderParam(value="x-ms-recursive") Boolean var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}/{directory}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<DirectoriesRenameHeaders, Void>> rename(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @PathParam(value="directory") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-file-rename-source") String var8, @HeaderParam(value="x-ms-file-rename-replace-if-exists") Boolean var9, @HeaderParam(value="x-ms-file-rename-ignore-readonly") Boolean var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="x-ms-destination-lease-id") String var12, @HeaderParam(value="x-ms-file-attributes") String var13, @HeaderParam(value="x-ms-file-creation-time") String var14, @HeaderParam(value="x-ms-file-last-write-time") String var15, @HeaderParam(value="x-ms-file-change-time") String var16, @HeaderParam(value="x-ms-file-permission") String var17, @HeaderParam(value="x-ms-file-permission-key") String var18, @HeaderParam(value="x-ms-meta-") Map<String, String> var19, @HeaderParam(value="Accept") String var20, Context var21);
    }
}

