/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.SignedIdentifiersWrapper;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.SharePermission;
import com.azure.storage.file.share.implementation.models.ShareStats;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesBreakLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreatePermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesCreateSnapshotHeaders;
import com.azure.storage.file.share.implementation.models.SharesDeleteHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPermissionHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetPropertiesHeaders;
import com.azure.storage.file.share.implementation.models.SharesGetStatisticsHeaders;
import com.azure.storage.file.share.implementation.models.SharesReleaseLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRestoreHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetAccessPolicyHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetMetadataHeaders;
import com.azure.storage.file.share.implementation.models.SharesSetPropertiesHeaders;
import com.azure.storage.file.share.models.ShareAccessTier;
import com.azure.storage.file.share.models.ShareRootSquash;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.storage.file.share.models.ShareStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class SharesImpl {
    private final SharesService service;
    private final AzureFileStorageImpl client;

    SharesImpl(AzureFileStorageImpl client) {
        this.service = (SharesService)RestProxy.create(SharesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash) {
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateHeaders, Void>> createWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), shareName, "share", timeout, metadata, quota, accessTier, this.client.getVersion(), enabledProtocols, rootSquash, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash) {
        return this.createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String shareName, Integer timeout, Map<String, String> metadata, Integer quota, ShareAccessTier accessTier, String enabledProtocols, ShareRootSquash rootSquash, Context context) {
        return this.createWithResponseAsync(shareName, timeout, metadata, quota, accessTier, enabledProtocols, rootSquash, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getProperties(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId) {
        return this.getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String shareName, String sharesnapshot, Integer timeout, String leaseId, Context context) {
        return this.getPropertiesWithResponseAsync(shareName, sharesnapshot, timeout, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesDeleteHeaders, Void>> deleteWithResponseAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        String restype = "share";
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), shareName, "share", sharesnapshot, timeout, this.client.getVersion(), deleteSnapshots, leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId) {
        return this.deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String shareName, String sharesnapshot, Integer timeout, DeleteSnapshotsOptionType deleteSnapshots, String leaseId, Context context) {
        return this.deleteWithResponseAsync(shareName, sharesnapshot, timeout, deleteSnapshots, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.acquireLease(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLeaseWithResponseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        String restype = "share";
        String accept = "application/xml";
        return this.service.acquireLease(this.client.getUrl(), shareName, "lease", "acquire", "share", timeout, duration, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId) {
        return this.acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> acquireLeaseAsync(String shareName, Integer timeout, Integer duration, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        return this.acquireLeaseWithResponseAsync(shareName, timeout, duration, proposedLeaseId, sharesnapshot, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.releaseLease(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        String restype = "share";
        String accept = "application/xml";
        return this.service.releaseLease(this.client.getUrl(), shareName, "lease", "release", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return this.releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        return this.releaseLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.changeLease(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        String restype = "share";
        String accept = "application/xml";
        return this.service.changeLease(this.client.getUrl(), shareName, "lease", "change", "share", timeout, leaseId, proposedLeaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId) {
        return this.changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> changeLeaseAsync(String shareName, String leaseId, Integer timeout, String proposedLeaseId, String sharesnapshot, String requestId, Context context) {
        return this.changeLeaseWithResponseAsync(shareName, leaseId, timeout, proposedLeaseId, sharesnapshot, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.renewLease(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLeaseWithResponseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        String restype = "share";
        String accept = "application/xml";
        return this.service.renewLease(this.client.getUrl(), shareName, "lease", "renew", "share", timeout, leaseId, this.client.getVersion(), sharesnapshot, requestId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId) {
        return this.renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renewLeaseAsync(String shareName, String leaseId, Integer timeout, String sharesnapshot, String requestId, Context context) {
        return this.renewLeaseWithResponseAsync(shareName, leaseId, timeout, sharesnapshot, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.breakLease(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLeaseWithResponseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        String comp = "lease";
        String action = "break";
        String restype = "share";
        String accept = "application/xml";
        return this.service.breakLease(this.client.getUrl(), shareName, "lease", "break", "share", timeout, breakPeriod, leaseId, this.client.getVersion(), requestId, sharesnapshot, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot) {
        return this.breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLeaseAsync(String shareName, Integer timeout, Integer breakPeriod, String leaseId, String requestId, String sharesnapshot, Context context) {
        return this.breakLeaseWithResponseAsync(shareName, timeout, breakPeriod, leaseId, requestId, sharesnapshot, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        String restype = "share";
        String comp = "snapshot";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.createSnapshot(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshotWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        String restype = "share";
        String comp = "snapshot";
        String accept = "application/xml";
        return this.service.createSnapshot(this.client.getUrl(), shareName, "share", "snapshot", timeout, metadata, this.client.getVersion(), "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata) {
        return this.createSnapshotWithResponseAsync(shareName, timeout, metadata).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createSnapshotAsync(String shareName, Integer timeout, Map<String, String> metadata, Context context) {
        return this.createSnapshotWithResponseAsync(shareName, timeout, metadata, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.createPermission(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), sharePermission, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermissionWithResponseAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/xml";
        return this.service.createPermission(this.client.getUrl(), shareName, "share", "filepermission", timeout, this.client.getVersion(), sharePermission, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout) {
        return this.createPermissionWithResponseAsync(shareName, sharePermission, timeout).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createPermissionAsync(String shareName, SharePermission sharePermission, Integer timeout, Context context) {
        return this.createPermissionWithResponseAsync(shareName, sharePermission, timeout, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(String shareName, String filePermissionKey, Integer timeout) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPermission(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, timeout, this.client.getVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermissionWithResponseAsync(String shareName, String filePermissionKey, Integer timeout, Context context) {
        String restype = "share";
        String comp = "filepermission";
        String accept = "application/json";
        return this.service.getPermission(this.client.getUrl(), shareName, "share", "filepermission", filePermissionKey, timeout, this.client.getVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey, Integer timeout) {
        return this.getPermissionWithResponseAsync(shareName, filePermissionKey, timeout).flatMap(res -> Mono.justOrEmpty((Object)((SharePermission)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharePermission> getPermissionAsync(String shareName, String filePermissionKey, Integer timeout, Context context) {
        return this.getPermissionWithResponseAsync(shareName, filePermissionKey, timeout, context).flatMap(res -> Mono.justOrEmpty((Object)((SharePermission)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash) {
        String restype = "share";
        String comp = "properties";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setProperties(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setPropertiesWithResponseAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Context context) {
        String restype = "share";
        String comp = "properties";
        String accept = "application/xml";
        return this.service.setProperties(this.client.getUrl(), shareName, "share", "properties", timeout, this.client.getVersion(), quota, accessTier, leaseId, rootSquash, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash) {
        return this.setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setPropertiesAsync(String shareName, Integer timeout, Integer quota, ShareAccessTier accessTier, String leaseId, ShareRootSquash rootSquash, Context context) {
        return this.setPropertiesWithResponseAsync(shareName, timeout, quota, accessTier, leaseId, rootSquash, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        String restype = "share";
        String comp = "metadata";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.setMetadata(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        String restype = "share";
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), shareName, "share", "metadata", timeout, metadata, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId) {
        return this.setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String shareName, Integer timeout, Map<String, String> metadata, String leaseId, Context context) {
        return this.setMetadataWithResponseAsync(shareName, timeout, metadata, leaseId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, List<ShareSignedIdentifier>>> getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetAccessPolicyHeaders, List<ShareSignedIdentifier>>> getAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<ShareSignedIdentifier>> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId) {
        return this.getAccessPolicyWithResponseAsync(shareName, timeout, leaseId).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<ShareSignedIdentifier>> getAccessPolicyAsync(String shareName, Integer timeout, String leaseId, Context context) {
        return this.getAccessPolicyWithResponseAsync(shareName, timeout, leaseId, context).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(shareAcl);
        return FluxUtil.withContext(context -> this.service.setAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, shareAclConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        String restype = "share";
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper shareAclConverted = new SignedIdentifiersWrapper(shareAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), shareName, "share", "acl", timeout, this.client.getVersion(), leaseId, shareAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl) {
        return this.setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String shareName, Integer timeout, String leaseId, List<ShareSignedIdentifier> shareAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(shareName, timeout, leaseId, shareAcl, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName, Integer timeout, String leaseId) {
        String restype = "share";
        String comp = "stats";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getStatistics(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatisticsWithResponseAsync(String shareName, Integer timeout, String leaseId, Context context) {
        String restype = "share";
        String comp = "stats";
        String accept = "application/xml";
        return this.service.getStatistics(this.client.getUrl(), shareName, "share", "stats", timeout, this.client.getVersion(), leaseId, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId) {
        return this.getStatisticsWithResponseAsync(shareName, timeout, leaseId).flatMap(res -> Mono.justOrEmpty((Object)((ShareStats)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareStats> getStatisticsAsync(String shareName, Integer timeout, String leaseId, Context context) {
        return this.getStatisticsWithResponseAsync(shareName, timeout, leaseId, context).flatMap(res -> Mono.justOrEmpty((Object)((ShareStats)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        String restype = "share";
        String comp = "undelete";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<SharesRestoreHeaders, Void>> restoreWithResponseAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        String restype = "share";
        String comp = "undelete";
        String accept = "application/xml";
        return this.service.restore(this.client.getUrl(), shareName, "share", "undelete", timeout, this.client.getVersion(), requestId, deletedShareName, deletedShareVersion, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion) {
        return this.restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String shareName, Integer timeout, String requestId, String deletedShareName, String deletedShareVersion, Context context) {
        return this.restoreWithResponseAsync(shareName, timeout, requestId, deletedShareName, deletedShareVersion, context).flatMap(ignored -> Mono.empty());
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureFileStorageShar")
    public static interface SharesService {
        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-share-quota") Integer var6, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-enabled-protocols") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="sharesnapshot") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesAcquireLeaseHeaders, Void>> acquireLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-duration") Integer var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesReleaseLeaseHeaders, Void>> releaseLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesChangeLeaseHeaders, Void>> changeLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-proposed-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @QueryParam(value="sharesnapshot") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesRenewLeaseHeaders, Void>> renewLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-version") String var8, @QueryParam(value="sharesnapshot") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesBreakLeaseHeaders, Void>> breakLease(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="comp") String var3, @HeaderParam(value="x-ms-lease-action") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-break-period") Integer var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="sharesnapshot") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesCreateSnapshotHeaders, Void>> createSnapshot(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesCreatePermissionHeaders, Void>> createPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @BodyParam(value="application/json") SharePermission var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesGetPermissionHeaders, SharePermission>> getPermission(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-file-permission-key") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesSetPropertiesHeaders, Void>> setProperties(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-share-quota") Integer var7, @HeaderParam(value="x-ms-access-tier") ShareAccessTier var8, @HeaderParam(value="x-ms-lease-id") String var9, @HeaderParam(value="x-ms-root-squash") ShareRootSquash var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-meta-") Map<String, String> var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesGetAccessPolicyHeaders, List<ShareSignedIdentifier>>> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @BodyParam(value="application/xml") SignedIdentifiersWrapper var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/{shareName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesGetStatisticsHeaders, ShareStats>> getStatistics(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{shareName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ShareStorageException.class)
        public Mono<ResponseBase<SharesRestoreHeaders, Void>> restore(@HostParam(value="url") String var1, @PathParam(value="shareName") String var2, @QueryParam(value="restype") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-deleted-share-name") String var8, @HeaderParam(value="x-ms-deleted-share-version") String var9, @HeaderParam(value="Accept") String var10, Context var11);
    }
}

