/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.models.ShareFileHandleAccessRights;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

@JacksonXmlRootElement(localName="Handle")
public final class HandleItem {
    @JsonProperty(value="HandleId", required=true)
    private String handleId;
    @JsonProperty(value="Path", required=true)
    private String path;
    @JsonProperty(value="FileId", required=true)
    private String fileId;
    @JsonProperty(value="ParentId")
    private String parentId;
    @JsonProperty(value="SessionId", required=true)
    private String sessionId;
    @JsonProperty(value="ClientIp", required=true)
    private String clientIp;
    @JsonProperty(value="OpenTime", required=true)
    private DateTimeRfc1123 openTime;
    @JsonProperty(value="LastReconnectTime")
    private DateTimeRfc1123 lastReconnectTime;
    @JsonProperty(value="AccessRightList")
    private AccessRightListWrapper accessRights;

    public String getHandleId() {
        return this.handleId;
    }

    public HandleItem setHandleId(String handleId) {
        this.handleId = handleId;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HandleItem setPath(String path) {
        this.path = path;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public HandleItem setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getParentId() {
        return this.parentId;
    }

    public HandleItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HandleItem setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public HandleItem setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public OffsetDateTime getOpenTime() {
        if (this.openTime == null) {
            return null;
        }
        return this.openTime.getDateTime();
    }

    public HandleItem setOpenTime(OffsetDateTime openTime) {
        this.openTime = openTime == null ? null : new DateTimeRfc1123(openTime);
        return this;
    }

    public OffsetDateTime getLastReconnectTime() {
        if (this.lastReconnectTime == null) {
            return null;
        }
        return this.lastReconnectTime.getDateTime();
    }

    public HandleItem setLastReconnectTime(OffsetDateTime lastReconnectTime) {
        this.lastReconnectTime = lastReconnectTime == null ? null : new DateTimeRfc1123(lastReconnectTime);
        return this;
    }

    public List<ShareFileHandleAccessRights> getAccessRights() {
        if (this.accessRights == null) {
            this.accessRights = new AccessRightListWrapper(new ArrayList());
        }
        return this.accessRights.items;
    }

    public HandleItem setAccessRights(List<ShareFileHandleAccessRights> accessRights) {
        this.accessRights = new AccessRightListWrapper(accessRights);
        return this;
    }

    private static final class AccessRightListWrapper {
        @JacksonXmlProperty(localName="AccessRight")
        private final List<ShareFileHandleAccessRights> items;

        @JsonCreator
        private AccessRightListWrapper(@JacksonXmlProperty(localName="AccessRight") List<ShareFileHandleAccessRights> items) {
            this.items = items;
        }
    }
}

