/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.StorageSeekableByteChannel;
import com.azure.storage.file.share.FileSmbProperties;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.StorageFileInputStream;
import com.azure.storage.file.share.StorageFileOutputStream;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileReadBehavior;
import com.azure.storage.file.share.StorageSeekableByteChannelShareFileWriteBehavior;
import com.azure.storage.file.share.models.CloseHandlesInfo;
import com.azure.storage.file.share.models.HandleItem;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import com.azure.storage.file.share.models.ShareFileCopyInfo;
import com.azure.storage.file.share.models.ShareFileDownloadAsyncResponse;
import com.azure.storage.file.share.models.ShareFileDownloadResponse;
import com.azure.storage.file.share.models.ShareFileHttpHeaders;
import com.azure.storage.file.share.models.ShareFileInfo;
import com.azure.storage.file.share.models.ShareFileMetadataInfo;
import com.azure.storage.file.share.models.ShareFileProperties;
import com.azure.storage.file.share.models.ShareFileRange;
import com.azure.storage.file.share.models.ShareFileRangeList;
import com.azure.storage.file.share.models.ShareFileUploadInfo;
import com.azure.storage.file.share.models.ShareFileUploadOptions;
import com.azure.storage.file.share.models.ShareFileUploadRangeFromUrlInfo;
import com.azure.storage.file.share.models.ShareFileUploadRangeOptions;
import com.azure.storage.file.share.models.ShareRequestConditions;
import com.azure.storage.file.share.options.ShareFileCopyOptions;
import com.azure.storage.file.share.options.ShareFileDownloadOptions;
import com.azure.storage.file.share.options.ShareFileListRangesDiffOptions;
import com.azure.storage.file.share.options.ShareFileRenameOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelReadOptions;
import com.azure.storage.file.share.options.ShareFileSeekableByteChannelWriteOptions;
import com.azure.storage.file.share.options.ShareFileUploadRangeFromUrlOptions;
import com.azure.storage.file.share.sas.ShareServiceSasSignatureValues;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareFileClientBuilder.class)
public class ShareFileClient {
    private final ShareFileAsyncClient shareFileAsyncClient;

    ShareFileClient(ShareFileAsyncClient shareFileAsyncClient) {
        this.shareFileAsyncClient = shareFileAsyncClient;
    }

    public String getAccountUrl() {
        return this.shareFileAsyncClient.getAccountUrl();
    }

    public String getFileUrl() {
        return this.shareFileAsyncClient.getFileUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.shareFileAsyncClient.getServiceVersion();
    }

    public final StorageFileInputStream openInputStream() {
        return this.openInputStream(new ShareFileRange(0L));
    }

    public final StorageFileInputStream openInputStream(ShareFileRange range) {
        return new StorageFileInputStream(this.shareFileAsyncClient, range.getStart(), range.getEnd() == null ? null : Long.valueOf(range.getEnd() - range.getStart() + 1L));
    }

    public final StorageFileOutputStream getFileOutputStream() {
        return this.getFileOutputStream(0L);
    }

    public final StorageFileOutputStream getFileOutputStream(long offset) {
        return new StorageFileOutputStream(this.shareFileAsyncClient, offset);
    }

    public SeekableByteChannel getFileSeekableByteChannelWrite(ShareFileSeekableByteChannelWriteOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (options.isOverwriteMode()) {
            Objects.requireNonNull(options.getFileSizeInBytes(), "'options.getFileSize()' cannot return null.");
            this.create(options.getFileSizeInBytes());
        }
        int chunkSize = options.getChunkSizeInBytes() != null ? options.getChunkSizeInBytes().intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, (StorageSeekableByteChannel.WriteBehavior)new StorageSeekableByteChannelShareFileWriteBehavior(this, options.getRequestConditions(), options.getFileLastWrittenMode()), 0L);
    }

    public SeekableByteChannel getFileSeekableByteChannelRead(ShareFileSeekableByteChannelReadOptions options) {
        ShareRequestConditions conditions = options != null ? options.getRequestConditions() : null;
        Long configuredChunkSize = options != null ? options.getChunkSizeInBytes() : null;
        int chunkSize = configuredChunkSize != null ? configuredChunkSize.intValue() : 0x400000;
        return new StorageSeekableByteChannel(chunkSize, (StorageSeekableByteChannel.ReadBehavior)new StorageSeekableByteChannelShareFileReadBehavior(this, conditions), 0L);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.shareFileAsyncClient.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo create(long maxSize) {
        return (ShareFileInfo)this.createWithResponse(maxSize, null, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, Duration timeout, Context context) {
        return this.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> createWithResponse(long maxSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileInfo>> response = this.shareFileAsyncClient.createWithResponse(maxSize, httpHeaders, smbProperties, filePermission, metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, Duration pollInterval) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setMetadata(metadata);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, FileSmbProperties smbProperties, String filePermission, PermissionCopyModeType filePermissionCopyMode, Boolean ignoreReadOnly, Boolean setArchiveAttribute, Map<String, String> metadata, Duration pollInterval, ShareRequestConditions destinationRequestConditions) {
        ShareFileCopyOptions options = new ShareFileCopyOptions().setSmbProperties(smbProperties).setFilePermission(filePermission).setPermissionCopyModeType(filePermissionCopyMode).setIgnoreReadOnly(ignoreReadOnly).setArchiveAttribute(setArchiveAttribute).setMetadata(metadata).setDestinationRequestConditions(destinationRequestConditions);
        return this.beginCopy(sourceUrl, options, pollInterval);
    }

    public SyncPoller<ShareFileCopyInfo, Void> beginCopy(String sourceUrl, ShareFileCopyOptions options, Duration pollInterval) {
        return this.shareFileAsyncClient.beginCopy(sourceUrl, options, pollInterval).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortCopy(String copyId) {
        this.abortCopyWithResponse(copyId, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, Duration timeout, Context context) {
        return this.abortCopyWithResponse(copyId, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> abortCopyWithResponse(String copyId, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareFileAsyncClient.abortCopyWithResponse(copyId, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties downloadToFile(String downloadFilePath) {
        return (ShareFileProperties)this.downloadToFileWithResponse(downloadFilePath, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(downloadFilePath, range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> downloadToFileWithResponse(String downloadFilePath, ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.downloadToFileWithResponse(downloadFilePath, range, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void download(OutputStream stream) {
        this.downloadWithResponse(stream, null, null, null, Context.NONE);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, range, rangeGetContentMD5, null, timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileRange range, Boolean rangeGetContentMD5, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.downloadWithResponse(stream, new ShareFileDownloadOptions().setRange(range).setRangeContentMd5Requested(rangeGetContentMD5).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileDownloadResponse downloadWithResponse(OutputStream stream, ShareFileDownloadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(stream, "'stream' cannot be null.");
        Mono download = this.shareFileAsyncClient.downloadWithResponse(options, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)((Flux)response.getValue()), (OutputStream)stream).thenReturn((Object)new ShareFileDownloadResponse((ShareFileDownloadAsyncResponse)((Object)response))));
        return (ShareFileDownloadResponse)((Object)StorageImplUtils.blockWithOptionalTimeout((Mono)download, (Duration)timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return this.deleteWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.shareFileAsyncClient.deleteWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.shareFileAsyncClient.deleteIfExistsWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileProperties getProperties() {
        return (ShareFileProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        return this.getPropertiesWithResponse(null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileProperties> getPropertiesWithResponse(ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileProperties>> response = this.shareFileAsyncClient.getPropertiesWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileInfo setProperties(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission) {
        return (ShareFileInfo)this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, Duration timeout, Context context) {
        return this.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileInfo> setPropertiesWithResponse(long newFileSize, ShareFileHttpHeaders httpHeaders, FileSmbProperties smbProperties, String filePermission, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileInfo>> response = this.shareFileAsyncClient.setPropertiesWithResponse(newFileSize, httpHeaders, smbProperties, filePermission, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileMetadataInfo setMetadata(Map<String, String> metadata) {
        return (ShareFileMetadataInfo)this.setMetadataWithResponse(metadata, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        return this.setMetadataWithResponse(metadata, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileMetadataInfo> setMetadataWithResponse(Map<String, String> metadata, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileMetadataInfo>> response = this.shareFileAsyncClient.setMetadataWithResponse(metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo upload(InputStream data, long length) {
        return (ShareFileUploadInfo)this.uploadWithResponse(data, length, 0L, null, Context.NONE).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, Duration timeout, Context context) {
        return this.uploadWithResponse(data, length, offset, null, timeout, context);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> uploadWithResponse(InputStream data, long length, Long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length).setOffset(offset).setRequestConditions(requestConditions), timeout, context);
    }

    public ShareFileUploadInfo upload(InputStream data, long length, ParallelTransferOptions transferOptions) {
        return (ShareFileUploadInfo)this.uploadWithResponse(new ShareFileUploadOptions(data, length).setParallelTransferOptions(transferOptions), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadWithResponse(ShareFileUploadOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadWithResponse(options, context), (Duration)timeout);
    }

    public ShareFileUploadInfo uploadRange(InputStream data, long length) {
        return (ShareFileUploadInfo)this.uploadRangeWithResponse(new ShareFileUploadRangeOptions(data, length), null, Context.NONE).getValue();
    }

    public Response<ShareFileUploadInfo> uploadRangeWithResponse(ShareFileUploadRangeOptions options, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.shareFileAsyncClient.uploadRangeWithResponse(options, context), (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadRangeFromUrlInfo uploadRangeFromUrl(long length, long destinationOffset, long sourceOffset, String sourceUrl) {
        return (ShareFileUploadRangeFromUrlInfo)this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(length, destinationOffset, sourceOffset, sourceUrl, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(long length, long destinationOffset, long sourceOffset, String sourceUrl, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return this.uploadRangeFromUrlWithResponse(new ShareFileUploadRangeFromUrlOptions(length, sourceUrl).setDestinationOffset(destinationOffset).setSourceOffset(sourceOffset).setDestinationRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadRangeFromUrlInfo> uploadRangeFromUrlWithResponse(ShareFileUploadRangeFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<ShareFileUploadRangeFromUrlInfo>> response = this.shareFileAsyncClient.uploadRangeFromUrlWithResponse(options, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileUploadInfo clearRange(long length) {
        return (ShareFileUploadInfo)this.clearRangeWithResponse(length, 0L, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, Duration timeout, Context context) {
        return this.clearRangeWithResponse(length, offset, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileUploadInfo> clearRangeWithResponse(long length, long offset, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<ShareFileUploadInfo>> response = this.shareFileAsyncClient.clearRangeWithResponse(length, offset, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath) {
        this.uploadFromFile(uploadFilePath, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String uploadFilePath, ShareRequestConditions requestConditions) {
        this.shareFileAsyncClient.uploadFromFile(uploadFilePath, requestConditions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges() {
        return this.listRanges(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, Duration timeout, Context context) {
        return this.listRanges(range, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ShareFileRange> listRanges(ShareFileRange range, ShareRequestConditions requestConditions, Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.listRangesWithOptionalTimeout(range, requestConditions, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileRangeList listRangesDiff(String previousSnapshot) {
        return (ShareFileRangeList)this.listRangesDiffWithResponse(new ShareFileListRangesDiffOptions(previousSnapshot), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileRangeList> listRangesDiffWithResponse(ShareFileListRangesDiffOptions options, Duration timeout, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Mono<Response<ShareFileRangeList>> response = this.shareFileAsyncClient.listRangesWithResponse(options.getRange(), options.getRequestConditions(), options.getPreviousSnapshot(), context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles() {
        return this.listHandles(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HandleItem> listHandles(Integer maxResultsPerPage, Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.listHandlesWithOptionalTimeout(maxResultsPerPage, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseHandle(String handleId) {
        return (CloseHandlesInfo)this.forceCloseHandleWithResponse(handleId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloseHandlesInfo> forceCloseHandleWithResponse(String handleId, Duration timeout, Context context) {
        Mono<Response<CloseHandlesInfo>> response = this.shareFileAsyncClient.forceCloseHandleWithResponse(handleId, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloseHandlesInfo forceCloseAllHandles(Duration timeout, Context context) {
        return new PagedIterable(this.shareFileAsyncClient.forceCloseAllHandlesWithOptionalTimeout(timeout, context)).stream().reduce(new CloseHandlesInfo(0, 0), (accu, next) -> new CloseHandlesInfo(accu.getClosedHandles() + next.getClosedHandles(), accu.getFailedHandles() + next.getFailedHandles()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ShareFileClient rename(String destinationPath) {
        return (ShareFileClient)this.renameWithResponse(new ShareFileRenameOptions(destinationPath), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ShareFileClient> renameWithResponse(ShareFileRenameOptions options, Duration timeout, Context context) {
        Mono<Response<ShareFileAsyncClient>> mono = this.shareFileAsyncClient.renameWithResponse(options, context);
        Response response = (Response)StorageImplUtils.blockWithOptionalTimeout(mono, (Duration)timeout);
        return new SimpleResponse(response, (Object)new ShareFileClient((ShareFileAsyncClient)response.getValue()));
    }

    public String getShareSnapshotId() {
        return this.shareFileAsyncClient.getShareSnapshotId();
    }

    public String getShareName() {
        return this.shareFileAsyncClient.getShareName();
    }

    public String getFilePath() {
        return this.shareFileAsyncClient.getFilePath();
    }

    public String getAccountName() {
        return this.shareFileAsyncClient.getAccountName();
    }

    public HttpPipeline getHttpPipeline() {
        return this.shareFileAsyncClient.getHttpPipeline();
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues) {
        return this.shareFileAsyncClient.generateSas(shareServiceSasSignatureValues);
    }

    public String generateSas(ShareServiceSasSignatureValues shareServiceSasSignatureValues, Context context) {
        return this.shareFileAsyncClient.generateSas(shareServiceSasSignatureValues, context);
    }
}

