// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameter group.
 */
@Fluent
public final class SourceLeaseAccessConditions implements JsonSerializable<SourceLeaseAccessConditions> {
    /*
     * Required if the source file has an active infinite lease.
     */
    private String sourceLeaseId;

    /**
     * Creates an instance of SourceLeaseAccessConditions class.
     */
    public SourceLeaseAccessConditions() {
    }

    /**
     * Get the sourceLeaseId property: Required if the source file has an active infinite lease.
     * 
     * @return the sourceLeaseId value.
     */
    public String getSourceLeaseId() {
        return this.sourceLeaseId;
    }

    /**
     * Set the sourceLeaseId property: Required if the source file has an active infinite lease.
     * 
     * @param sourceLeaseId the sourceLeaseId value to set.
     * @return the SourceLeaseAccessConditions object itself.
     */
    public SourceLeaseAccessConditions setSourceLeaseId(String sourceLeaseId) {
        this.sourceLeaseId = sourceLeaseId;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceLeaseId", this.sourceLeaseId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceLeaseAccessConditions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceLeaseAccessConditions if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceLeaseAccessConditions.
     */
    public static SourceLeaseAccessConditions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceLeaseAccessConditions deserializedSourceLeaseAccessConditions = new SourceLeaseAccessConditions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceLeaseId".equals(fieldName)) {
                    deserializedSourceLeaseAccessConditions.sourceLeaseId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceLeaseAccessConditions;
        });
    }
}
