// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The request intent specifies requests that are intended for backup/admin type operations, meaning that all
 * file/directory ACLs are bypassed and full permissions are granted. User must also have required RBAC permission.
 */
public final class ShareTokenIntent extends ExpandableStringEnum<ShareTokenIntent> {
    /**
     * Static value backup for ShareTokenIntent.
     */
    public static final ShareTokenIntent BACKUP = fromString("backup");

    /**
     * Creates a new instance of ShareTokenIntent value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ShareTokenIntent() {
    }

    /**
     * Creates or finds a ShareTokenIntent from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ShareTokenIntent.
     */
    public static ShareTokenIntent fromString(String name) {
        return fromString(name, ShareTokenIntent.class);
    }

    /**
     * Gets known ShareTokenIntent values.
     * 
     * @return known ShareTokenIntent values.
     */
    public static Collection<ShareTokenIntent> values() {
        return values(ShareTokenIntent.class);
    }
}
