// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameter group.
 */
@Fluent
public final class SourceModifiedAccessConditions implements JsonSerializable<SourceModifiedAccessConditions> {
    /*
     * Specify the crc64 value to operate only on range with a matching crc64 checksum.
     */
    private byte[] sourceIfMatchCrc64;

    /*
     * Specify the crc64 value to operate only on range without a matching crc64 checksum.
     */
    private byte[] sourceIfNoneMatchCrc64;

    /**
     * Creates an instance of SourceModifiedAccessConditions class.
     */
    public SourceModifiedAccessConditions() {
    }

    /**
     * Get the sourceIfMatchCrc64 property: Specify the crc64 value to operate only on range with a matching crc64
     * checksum.
     * 
     * @return the sourceIfMatchCrc64 value.
     */
    public byte[] getSourceIfMatchCrc64() {
        return CoreUtils.clone(this.sourceIfMatchCrc64);
    }

    /**
     * Set the sourceIfMatchCrc64 property: Specify the crc64 value to operate only on range with a matching crc64
     * checksum.
     * 
     * @param sourceIfMatchCrc64 the sourceIfMatchCrc64 value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfMatchCrc64(byte[] sourceIfMatchCrc64) {
        this.sourceIfMatchCrc64 = CoreUtils.clone(sourceIfMatchCrc64);
        return this;
    }

    /**
     * Get the sourceIfNoneMatchCrc64 property: Specify the crc64 value to operate only on range without a matching
     * crc64 checksum.
     * 
     * @return the sourceIfNoneMatchCrc64 value.
     */
    public byte[] getSourceIfNoneMatchCrc64() {
        return CoreUtils.clone(this.sourceIfNoneMatchCrc64);
    }

    /**
     * Set the sourceIfNoneMatchCrc64 property: Specify the crc64 value to operate only on range without a matching
     * crc64 checksum.
     * 
     * @param sourceIfNoneMatchCrc64 the sourceIfNoneMatchCrc64 value to set.
     * @return the SourceModifiedAccessConditions object itself.
     */
    public SourceModifiedAccessConditions setSourceIfNoneMatchCrc64(byte[] sourceIfNoneMatchCrc64) {
        this.sourceIfNoneMatchCrc64 = CoreUtils.clone(sourceIfNoneMatchCrc64);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("sourceIfMatchCrc64", this.sourceIfMatchCrc64);
        jsonWriter.writeBinaryField("sourceIfNoneMatchCrc64", this.sourceIfNoneMatchCrc64);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SourceModifiedAccessConditions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SourceModifiedAccessConditions if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SourceModifiedAccessConditions.
     */
    public static SourceModifiedAccessConditions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SourceModifiedAccessConditions deserializedSourceModifiedAccessConditions
                = new SourceModifiedAccessConditions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceIfMatchCrc64".equals(fieldName)) {
                    deserializedSourceModifiedAccessConditions.sourceIfMatchCrc64 = reader.getBinary();
                } else if ("sourceIfNoneMatchCrc64".equals(fieldName)) {
                    deserializedSourceModifiedAccessConditions.sourceIfNoneMatchCrc64 = reader.getBinary();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSourceModifiedAccessConditions;
        });
    }
}
