/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.sas.CommonSasQueryParameters;
import com.azure.storage.file.share.ShareDirectoryAsyncClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileAsyncClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.util.BuilderHelper;
import com.azure.storage.file.share.models.ShareAudience;
import com.azure.storage.file.share.models.ShareTokenIntent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ShareFileClient.class, ShareFileAsyncClient.class, ShareDirectoryClient.class, ShareDirectoryAsyncClient.class})
public class ShareFileClientBuilder
implements TokenCredentialTrait<ShareFileClientBuilder>,
HttpTrait<ShareFileClientBuilder>,
ConnectionStringTrait<ShareFileClientBuilder>,
AzureNamedKeyCredentialTrait<ShareFileClientBuilder>,
AzureSasCredentialTrait<ShareFileClientBuilder>,
ConfigurationTrait<ShareFileClientBuilder>,
EndpointTrait<ShareFileClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ShareFileClientBuilder.class);
    private String endpoint;
    private String accountName;
    private String shareName;
    private String shareSnapshot;
    private String resourcePath;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private AzureSasCredential azureSasCredential;
    private TokenCredential tokenCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private ShareServiceVersion version;
    private ShareTokenIntent shareTokenIntent;
    private boolean allowSourceTrailingDot;
    private boolean allowTrailingDot;
    private ShareAudience audience;

    public ShareFileClientBuilder() {
        this.logOptions = ShareFileClientBuilder.getDefaultHttpLogOptions();
    }

    private ShareServiceVersion getServiceVersion() {
        return this.version != null ? this.version : ShareServiceVersion.getLatest();
    }

    private AzureFileStorageImpl constructImpl(ShareServiceVersion serviceVersion) {
        Objects.requireNonNull(this.shareName, "'shareName' cannot be null.");
        Objects.requireNonNull(this.resourcePath, "'resourcePath' cannot be null.");
        CredentialValidator.validateSingleCredentialIsPresent((StorageSharedKeyCredential)this.storageSharedKeyCredential, null, (AzureSasCredential)this.azureSasCredential, (String)this.sasToken, (ClientLogger)LOGGER);
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
        return new AzureFileStorageImpl(pipeline, serviceVersion.getVersion(), this.shareTokenIntent, this.endpoint, this.allowTrailingDot, this.allowSourceTrailingDot);
    }

    public ShareDirectoryAsyncClient buildDirectoryAsyncClient() {
        ShareServiceVersion serviceVersion = this.getServiceVersion();
        return new ShareDirectoryAsyncClient(this.constructImpl(serviceVersion), this.shareName, this.resourcePath, this.shareSnapshot, this.accountName, serviceVersion, this.sasToken != null ? new AzureSasCredential(this.sasToken) : this.azureSasCredential);
    }

    public ShareDirectoryClient buildDirectoryClient() {
        return new ShareDirectoryClient(this.buildDirectoryAsyncClient());
    }

    public ShareFileAsyncClient buildFileAsyncClient() {
        ShareServiceVersion serviceVersion = this.getServiceVersion();
        return new ShareFileAsyncClient(this.constructImpl(serviceVersion), this.shareName, this.resourcePath, this.shareSnapshot, this.accountName, serviceVersion, this.sasToken != null ? new AzureSasCredential(this.sasToken) : this.azureSasCredential);
    }

    public ShareFileClient buildFileClient() {
        return new ShareFileClient(this.buildFileAsyncClient());
    }

    public ShareFileClientBuilder endpoint(String endpoint) {
        try {
            String sasToken;
            URL fullUrl = new URL(endpoint);
            this.endpoint = fullUrl.getProtocol() + "://" + fullUrl.getHost();
            this.accountName = BuilderHelper.getAccountName(fullUrl);
            String[] pathSegments = fullUrl.getPath().split("/");
            int length = pathSegments.length;
            this.shareName = length >= 2 ? pathSegments[1] : this.shareName;
            CharSequence[] filePathParams = length >= 3 ? Arrays.copyOfRange(pathSegments, 2, length) : null;
            this.resourcePath = filePathParams != null ? String.join((CharSequence)"/", filePathParams) : this.resourcePath;
            Map queryParamsMap = SasImplUtils.parseQueryString((String)fullUrl.getQuery());
            String[] snapshotArray = (String[])queryParamsMap.remove("sharesnapshot");
            if (snapshotArray != null) {
                this.shareSnapshot = snapshotArray[0];
            }
            if (!CoreUtils.isNullOrEmpty((CharSequence)(sasToken = new CommonSasQueryParameters(SasImplUtils.parseQueryString((String)fullUrl.getQuery()), false).encode()))) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage File endpoint url is malformed.", ex));
        }
        return this;
    }

    public ShareFileClientBuilder shareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    public ShareFileClientBuilder snapshot(String snapshot) {
        this.shareSnapshot = snapshot;
        return this;
    }

    public ShareFileClientBuilder resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public ShareFileClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public ShareFileClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential((AzureNamedKeyCredential)credential));
    }

    public ShareFileClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public ShareFileClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public ShareFileClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public ShareFileClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getFileEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive file service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public ShareFileClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public ShareFileClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public ShareFileClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public ShareFileClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ShareFileClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ShareFileClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    public ShareFileClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public ShareFileClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public ShareFileClientBuilder serviceVersion(ShareServiceVersion version) {
        this.version = version;
        return this;
    }

    public ShareFileClientBuilder allowSourceTrailingDot(boolean allowSourceTrailingDot) {
        this.allowSourceTrailingDot = allowSourceTrailingDot;
        return this;
    }

    public ShareFileClientBuilder allowTrailingDot(boolean allowTrailingDot) {
        this.allowTrailingDot = allowTrailingDot;
        return this;
    }

    public ShareFileClientBuilder shareTokenIntent(ShareTokenIntent shareTokenIntent) {
        this.shareTokenIntent = shareTokenIntent;
        return this;
    }

    public ShareFileClientBuilder audience(ShareAudience audience) {
        this.audience = audience;
        return this;
    }
}

