/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.storage.file.share.models.PermissionCopyModeType;
import java.io.IOException;

public final class CopyFileSmbInfo
implements JsonSerializable<CopyFileSmbInfo> {
    private String fileAttributes;
    private String fileCreationTime;
    private String fileLastWriteTime;
    private String fileChangeTime;
    private PermissionCopyModeType filePermissionCopyMode;
    private Boolean ignoreReadOnly;
    private Boolean setArchiveAttribute;

    public String getFileAttributes() {
        return this.fileAttributes;
    }

    public CopyFileSmbInfo setFileAttributes(String fileAttributes) {
        this.fileAttributes = fileAttributes;
        return this;
    }

    public String getFileCreationTime() {
        return this.fileCreationTime;
    }

    public CopyFileSmbInfo setFileCreationTime(String fileCreationTime) {
        this.fileCreationTime = fileCreationTime;
        return this;
    }

    public String getFileLastWriteTime() {
        return this.fileLastWriteTime;
    }

    public CopyFileSmbInfo setFileLastWriteTime(String fileLastWriteTime) {
        this.fileLastWriteTime = fileLastWriteTime;
        return this;
    }

    public String getFileChangeTime() {
        return this.fileChangeTime;
    }

    public CopyFileSmbInfo setFileChangeTime(String fileChangeTime) {
        this.fileChangeTime = fileChangeTime;
        return this;
    }

    public PermissionCopyModeType getFilePermissionCopyMode() {
        return this.filePermissionCopyMode;
    }

    public CopyFileSmbInfo setFilePermissionCopyMode(PermissionCopyModeType filePermissionCopyMode) {
        this.filePermissionCopyMode = filePermissionCopyMode;
        return this;
    }

    public Boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    public CopyFileSmbInfo setIgnoreReadOnly(Boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
        return this;
    }

    public Boolean isSetArchiveAttribute() {
        return this.setArchiveAttribute;
    }

    public CopyFileSmbInfo setSetArchiveAttribute(Boolean setArchiveAttribute) {
        this.setArchiveAttribute = setArchiveAttribute;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileAttributes", this.fileAttributes);
        jsonWriter.writeStringField("fileCreationTime", this.fileCreationTime);
        jsonWriter.writeStringField("fileLastWriteTime", this.fileLastWriteTime);
        jsonWriter.writeStringField("fileChangeTime", this.fileChangeTime);
        jsonWriter.writeStringField("filePermissionCopyMode", this.filePermissionCopyMode == null ? null : this.filePermissionCopyMode.toString());
        jsonWriter.writeBooleanField("ignoreReadOnly", this.ignoreReadOnly);
        jsonWriter.writeBooleanField("setArchiveAttribute", this.setArchiveAttribute);
        return jsonWriter.writeEndObject();
    }

    public static CopyFileSmbInfo fromJson(JsonReader jsonReader) throws IOException {
        return (CopyFileSmbInfo)jsonReader.readObject(reader -> {
            CopyFileSmbInfo deserializedCopyFileSmbInfo = new CopyFileSmbInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileAttributes".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.fileAttributes = reader.getString();
                    continue;
                }
                if ("fileCreationTime".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.fileCreationTime = reader.getString();
                    continue;
                }
                if ("fileLastWriteTime".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.fileLastWriteTime = reader.getString();
                    continue;
                }
                if ("fileChangeTime".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.fileChangeTime = reader.getString();
                    continue;
                }
                if ("filePermissionCopyMode".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.filePermissionCopyMode = PermissionCopyModeType.fromString(reader.getString());
                    continue;
                }
                if ("ignoreReadOnly".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.ignoreReadOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("setArchiveAttribute".equals(fieldName)) {
                    deserializedCopyFileSmbInfo.setArchiveAttribute = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCopyFileSmbInfo;
        });
    }
}

