/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ShareFileHttpHeaders
implements JsonSerializable<ShareFileHttpHeaders> {
    private String contentType;
    private String contentEncoding;
    private String contentLanguage;
    private String cacheControl;
    private byte[] contentMd5;
    private String contentDisposition;

    public String getContentType() {
        return this.contentType;
    }

    public ShareFileHttpHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public ShareFileHttpHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public ShareFileHttpHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public ShareFileHttpHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public ShareFileHttpHeaders setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public ShareFileHttpHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("contentEncoding", this.contentEncoding);
        jsonWriter.writeStringField("contentLanguage", this.contentLanguage);
        jsonWriter.writeStringField("cacheControl", this.cacheControl);
        jsonWriter.writeBinaryField("contentMd5", this.contentMd5);
        jsonWriter.writeStringField("contentDisposition", this.contentDisposition);
        return jsonWriter.writeEndObject();
    }

    public static ShareFileHttpHeaders fromJson(JsonReader jsonReader) throws IOException {
        return (ShareFileHttpHeaders)jsonReader.readObject(reader -> {
            ShareFileHttpHeaders deserializedShareFileHttpHeaders = new ShareFileHttpHeaders();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.contentType = reader.getString();
                    continue;
                }
                if ("contentEncoding".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.contentEncoding = reader.getString();
                    continue;
                }
                if ("contentLanguage".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.contentLanguage = reader.getString();
                    continue;
                }
                if ("cacheControl".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.cacheControl = reader.getString();
                    continue;
                }
                if ("contentMd5".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.contentMd5 = reader.getBinary();
                    continue;
                }
                if ("contentDisposition".equals(fieldName)) {
                    deserializedShareFileHttpHeaders.contentDisposition = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedShareFileHttpHeaders;
        });
    }
}

