/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.share.models.ShareSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareSignedIdentifierWrapper
implements XmlSerializable<ShareSignedIdentifierWrapper> {
    private final List<ShareSignedIdentifier> signedIdentifiers;

    public ShareSignedIdentifierWrapper(List<ShareSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    public List<ShareSignedIdentifier> items() {
        return this.signedIdentifiers;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.signedIdentifiers != null) {
            for (ShareSignedIdentifier element : this.signedIdentifiers) {
                xmlWriter.writeXml((XmlSerializable)element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareSignedIdentifierWrapper.fromXml(xmlReader, null);
    }

    public static ShareSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        return (ShareSignedIdentifierWrapper)xmlReader.readObject(rootElementName, reader -> {
            ArrayList<ShareSignedIdentifier> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<ShareSignedIdentifier>();
                    }
                    items.add(ShareSignedIdentifier.fromXml(reader));
                    continue;
                }
                reader.nextElement();
            }
            return new ShareSignedIdentifierWrapper(items);
        });
    }
}

