/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareAccessPolicy
implements XmlSerializable<ShareAccessPolicy> {
    private OffsetDateTime startsOn;
    private OffsetDateTime expiresOn;
    private String permissions;

    public OffsetDateTime getStartsOn() {
        return this.startsOn;
    }

    public ShareAccessPolicy setStartsOn(OffsetDateTime startsOn) {
        this.startsOn = startsOn;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public ShareAccessPolicy setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public ShareAccessPolicy setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "ShareAccessPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Start", this.startsOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startsOn));
        xmlWriter.writeStringElement("Expiry", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        xmlWriter.writeStringElement("Permission", this.permissions);
        return xmlWriter.writeEndElement();
    }

    public static ShareAccessPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareAccessPolicy.fromXml(xmlReader, null);
    }

    public static ShareAccessPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "ShareAccessPolicy" : rootElementName;
        return (ShareAccessPolicy)xmlReader.readObject(finalRootElementName, reader -> {
            ShareAccessPolicy deserializedShareAccessPolicy = new ShareAccessPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Start".equals(elementName.getLocalPart())) {
                    deserializedShareAccessPolicy.startsOn = (OffsetDateTime)reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Expiry".equals(elementName.getLocalPart())) {
                    deserializedShareAccessPolicy.expiresOn = (OffsetDateTime)reader.getNullableElement(dateString -> OffsetDateTime.parse(dateString));
                    continue;
                }
                if ("Permission".equals(elementName.getLocalPart())) {
                    deserializedShareAccessPolicy.permissions = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareAccessPolicy;
        });
    }
}

