/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.implementation.models.StringEncoded;
import com.azure.storage.file.share.models.ShareFileHandleAccessRights;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class HandleItem
implements XmlSerializable<HandleItem> {
    private String handleId;
    private StringEncoded path;
    private String fileId;
    private String parentId;
    private String sessionId;
    private String clientIp;
    private String clientName;
    private DateTimeRfc1123 openTime;
    private DateTimeRfc1123 lastReconnectTime;
    private List<ShareFileHandleAccessRights> accessRightList;

    public String getHandleId() {
        return this.handleId;
    }

    public HandleItem setHandleId(String handleId) {
        this.handleId = handleId;
        return this;
    }

    public StringEncoded getPath() {
        return this.path;
    }

    public HandleItem setPath(StringEncoded path) {
        this.path = path;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public HandleItem setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public String getParentId() {
        return this.parentId;
    }

    public HandleItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public HandleItem setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public HandleItem setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public HandleItem setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public OffsetDateTime getOpenTime() {
        if (this.openTime == null) {
            return null;
        }
        return this.openTime.getDateTime();
    }

    public HandleItem setOpenTime(OffsetDateTime openTime) {
        this.openTime = openTime == null ? null : new DateTimeRfc1123(openTime);
        return this;
    }

    public OffsetDateTime getLastReconnectTime() {
        if (this.lastReconnectTime == null) {
            return null;
        }
        return this.lastReconnectTime.getDateTime();
    }

    public HandleItem setLastReconnectTime(OffsetDateTime lastReconnectTime) {
        this.lastReconnectTime = lastReconnectTime == null ? null : new DateTimeRfc1123(lastReconnectTime);
        return this;
    }

    public List<ShareFileHandleAccessRights> getAccessRightList() {
        if (this.accessRightList == null) {
            this.accessRightList = new ArrayList<ShareFileHandleAccessRights>();
        }
        return this.accessRightList;
    }

    public HandleItem setAccessRightList(List<ShareFileHandleAccessRights> accessRightList) {
        this.accessRightList = accessRightList;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Handle" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("HandleId", this.handleId);
        xmlWriter.writeXml((XmlSerializable)this.path, "Path");
        xmlWriter.writeStringElement("FileId", this.fileId);
        xmlWriter.writeStringElement("ParentId", this.parentId);
        xmlWriter.writeStringElement("SessionId", this.sessionId);
        xmlWriter.writeStringElement("ClientIp", this.clientIp);
        xmlWriter.writeStringElement("ClientName", this.clientName);
        xmlWriter.writeStringElement("OpenTime", Objects.toString(this.openTime, null));
        xmlWriter.writeStringElement("LastReconnectTime", Objects.toString(this.lastReconnectTime, null));
        if (this.accessRightList != null) {
            xmlWriter.writeStartElement("AccessRightList");
            for (ShareFileHandleAccessRights element : this.accessRightList) {
                xmlWriter.writeStringElement("AccessRight", element == null ? null : element.toString());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static HandleItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return HandleItem.fromXml(xmlReader, null);
    }

    public static HandleItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Handle" : rootElementName;
        return (HandleItem)xmlReader.readObject(finalRootElementName, reader -> {
            HandleItem deserializedHandleItem = new HandleItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("HandleId".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.handleId = reader.getStringElement();
                    continue;
                }
                if ("Path".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.path = StringEncoded.fromXml(reader, "Path");
                    continue;
                }
                if ("FileId".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.fileId = reader.getStringElement();
                    continue;
                }
                if ("ParentId".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.parentId = reader.getStringElement();
                    continue;
                }
                if ("SessionId".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.sessionId = reader.getStringElement();
                    continue;
                }
                if ("ClientIp".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.clientIp = reader.getStringElement();
                    continue;
                }
                if ("ClientName".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.clientName = reader.getStringElement();
                    continue;
                }
                if ("OpenTime".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.openTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("LastReconnectTime".equals(elementName.getLocalPart())) {
                    deserializedHandleItem.lastReconnectTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("AccessRightList".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AccessRight".equals(elementName.getLocalPart())) {
                            if (deserializedHandleItem.accessRightList == null) {
                                deserializedHandleItem.accessRightList = new ArrayList<ShareFileHandleAccessRights>();
                            }
                            deserializedHandleItem.accessRightList.add(ShareFileHandleAccessRights.fromString(reader.getStringElement()));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedHandleItem;
        });
    }
}

