// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.file.share.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Abstract for entries that can be listed from Directory.
 */
@Fluent
public final class FilesAndDirectoriesListSegment implements XmlSerializable<FilesAndDirectoriesListSegment> {

    /*
     * The DirectoryItems property.
     */
    private List<DirectoryItem> directoryItems = new ArrayList<>();

    /*
     * The FileItems property.
     */
    private List<FileItem> fileItems = new ArrayList<>();

    /**
     * Creates an instance of FilesAndDirectoriesListSegment class.
     */
    public FilesAndDirectoriesListSegment() {
    }

    /**
     * Get the directoryItems property: The DirectoryItems property.
     *
     * @return the directoryItems value.
     */
    public List<DirectoryItem> getDirectoryItems() {
        return this.directoryItems;
    }

    /**
     * Set the directoryItems property: The DirectoryItems property.
     *
     * @param directoryItems the directoryItems value to set.
     * @return the FilesAndDirectoriesListSegment object itself.
     */
    public FilesAndDirectoriesListSegment setDirectoryItems(List<DirectoryItem> directoryItems) {
        this.directoryItems = directoryItems;
        return this;
    }

    /**
     * Get the fileItems property: The FileItems property.
     *
     * @return the fileItems value.
     */
    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    /**
     * Set the fileItems property: The FileItems property.
     *
     * @param fileItems the fileItems value to set.
     * @return the FilesAndDirectoriesListSegment object itself.
     */
    public FilesAndDirectoriesListSegment setFileItems(List<FileItem> fileItems) {
        this.fileItems = fileItems;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Entries" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.directoryItems != null) {
            for (DirectoryItem element : this.directoryItems) {
                xmlWriter.writeXml(element, "Directory");
            }
        }
        if (this.fileItems != null) {
            for (FileItem element : this.fileItems) {
                xmlWriter.writeXml(element, "File");
            }
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FilesAndDirectoriesListSegment from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of FilesAndDirectoriesListSegment if the XmlReader was pointing to an instance of it, or null
     * if it was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the FilesAndDirectoriesListSegment.
     */
    public static FilesAndDirectoriesListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FilesAndDirectoriesListSegment from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FilesAndDirectoriesListSegment if the XmlReader was pointing to an instance of it, or null
     * if it was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the FilesAndDirectoriesListSegment.
     */
    public static FilesAndDirectoriesListSegment fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Entries" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            FilesAndDirectoriesListSegment deserializedFilesAndDirectoriesListSegment
                = new FilesAndDirectoriesListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Directory".equals(elementName.getLocalPart())) {
                    if (deserializedFilesAndDirectoriesListSegment.directoryItems == null) {
                        deserializedFilesAndDirectoriesListSegment.directoryItems = new ArrayList<>();
                    }
                    deserializedFilesAndDirectoriesListSegment.directoryItems
                        .add(DirectoryItem.fromXml(reader, "Directory"));
                } else if ("File".equals(elementName.getLocalPart())) {
                    if (deserializedFilesAndDirectoriesListSegment.fileItems == null) {
                        deserializedFilesAndDirectoriesListSegment.fileItems = new ArrayList<>();
                    }
                    deserializedFilesAndDirectoriesListSegment.fileItems.add(FileItem.fromXml(reader, "File"));
                } else {
                    reader.skipElement();
                }
            }
            return deserializedFilesAndDirectoriesListSegment;
        });
    }
}
