// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Properties of a share.
 */
@Fluent
public final class ShareProperties implements XmlSerializable<ShareProperties> {
    /*
     * The lastModified property.
     */
    private DateTimeRfc1123 lastModified;

    /*
     * The eTag property.
     */
    private String eTag;

    /*
     * The quota property.
     */
    private int quota;

    /*
     * The provisionedIops property.
     */
    private Integer provisionedIops;

    /*
     * The provisionedIngressMBps property.
     */
    private Integer provisionedIngressMBps;

    /*
     * The provisionedEgressMBps property.
     */
    private Integer provisionedEgressMBps;

    /*
     * The nextAllowedQuotaDowngradeTime property.
     */
    private DateTimeRfc1123 nextAllowedQuotaDowngradeTime;

    /*
     * The deletedTime property.
     */
    private DateTimeRfc1123 deletedTime;

    /*
     * The remainingRetentionDays property.
     */
    private Integer remainingRetentionDays;

    /*
     * The accessTier property.
     */
    private String accessTier;

    /*
     * The accessTierChangeTime property.
     */
    private DateTimeRfc1123 accessTierChangeTime;

    /*
     * The accessTierTransitionState property.
     */
    private String accessTierTransitionState;

    /*
     * Possible values include: 'locked', 'unlocked'
     */
    private LeaseStatusType leaseStatus;

    /*
     * Possible values include: 'available', 'leased', 'expired', 'breaking',
     * 'broken'
     */
    private LeaseStateType leaseState;

    /*
     * Possible values include: 'infinite', 'fixed'
     */
    private LeaseDurationType leaseDuration;

    /*
     * The enabledProtocols property.
     */
    private ShareProtocols protocols;

    /*
     * Possible values include: 'NoRootSquash', 'RootSquash', 'AllSquash'
     */
    private ShareRootSquash rootSquash;

    /*
     * The metadata property.
     */
    private Map<String, String> metadata;

    /*
     * The provisioned bandwidth.
     */
    private Integer provisionedBandwidthMiBps;

    /*
     * The EnableSnapshotVirtualDirectoryAccess property.
     */
    private Boolean enableSnapshotVirtualDirectoryAccess;

    /*
     * If paid bursting is enabled.
     */
    private Boolean enablePaidBursting;

    /*
     * The maximum IOPS for paid bursting.
     */
    private Long paidBurstingMaxIops;

    /*
     * The maximum MiB/sec for paid bursting.
     */
    private Long paidBurstingMaxBandwidthMibps;

    /**
     * Get the lastModified property: The lastModified property.
     *
     * @return the lastModified value.
     */
    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    /**
     * Set the lastModified property: The lastModified property.
     *
     * @param lastModified the lastModified value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setLastModified(OffsetDateTime lastModified) {
        if (lastModified == null) {
            this.lastModified = null;
        } else {
            this.lastModified = new DateTimeRfc1123(lastModified);
        }
        return this;
    }

    /**
     * Get the eTag property: The eTag property.
     *
     * @return the eTag value.
     */
    public String getETag() {
        return this.eTag;
    }

    /**
     * Set the eTag property: The eTag property.
     *
     * @param eTag the eTag value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    /**
     * Get the quota property: The quota property.
     *
     * @return the quota value.
     */
    public int getQuota() {
        return this.quota;
    }

    /**
     * Set the quota property: The quota property.
     *
     * @param quota the quota value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setQuota(int quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Get the provisionedIops property: The provisionedIops property.
     *
     * @return the provisionedIops value.
     */
    public Integer getProvisionedIops() {
        return this.provisionedIops;
    }

    /**
     * Set the provisionedIops property: The provisionedIops property.
     *
     * @param provisionedIops the provisionedIops value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProvisionedIops(Integer provisionedIops) {
        this.provisionedIops = provisionedIops;
        return this;
    }

    /**
     * Get the provisionedIngressMBps property: The provisionedIngressMBps
     * property.
     *
     * @return the provisionedIngressMBps value.
     * @deprecated Please use {@link #getProvisionedBandwidthMiBps()}
     */
    @Deprecated
    public Integer getProvisionedIngressMBps() {
        return this.provisionedIngressMBps;
    }

    /**
     * Set the provisionedIngressMBps property: The provisionedIngressMBps
     * property.
     *
     * @param provisionedIngressMBps the provisionedIngressMBps value to set.
     * @return the ShareProperties object itself.
     * @deprecated Please use {@link #setProvisionedBandwidthMiBps(Integer)} ()}
     */
    @Deprecated
    public ShareProperties setProvisionedIngressMBps(Integer provisionedIngressMBps) {
        this.provisionedIngressMBps = provisionedIngressMBps;
        return this;
    }

    /**
     * Get the provisionedEgressMBps property: The provisionedEgressMBps
     * property.
     *
     * @return the provisionedEgressMBps value.
     * @deprecated Please use {@link #getProvisionedBandwidthMiBps()}
     */
    @Deprecated
    public Integer getProvisionedEgressMBps() {
        return this.provisionedEgressMBps;
    }

    /**
     * Set the provisionedEgressMBps property: The provisionedEgressMBps
     * property.
     *
     * @param provisionedEgressMBps the provisionedEgressMBps value to set.
     * @return the ShareProperties object itself.
     * @deprecated Please use {@link #setProvisionedBandwidthMiBps(Integer)} ()}
     */
    @Deprecated
    public ShareProperties setProvisionedEgressMBps(Integer provisionedEgressMBps) {
        this.provisionedEgressMBps = provisionedEgressMBps;
        return this;
    }

    /**
     * Get the provisionedBandwidthMiBps property: The ProvisionedBandwidthMiBps property.
     *
     * @return the provisionedBandwidthMiBps value.
     */
    public Integer getProvisionedBandwidthMiBps() {
        return this.provisionedBandwidthMiBps;
    }

    /**
     * Set the provisionedBandwidthMiBps property: The ProvisionedBandwidthMiBps property.
     *
     * @param provisionedBandwidthMiBps the provisionedBandwidthMiBps value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProvisionedBandwidthMiBps(Integer provisionedBandwidthMiBps) {
        this.provisionedBandwidthMiBps = provisionedBandwidthMiBps;
        return this;
    }

    /**
     * Get the nextAllowedQuotaDowngradeTime property: The
     * nextAllowedQuotaDowngradeTime property.
     *
     * @return the nextAllowedQuotaDowngradeTime value.
     */
    public OffsetDateTime getNextAllowedQuotaDowngradeTime() {
        if (this.nextAllowedQuotaDowngradeTime == null) {
            return null;
        }
        return this.nextAllowedQuotaDowngradeTime.getDateTime();
    }

    /**
     * Set the nextAllowedQuotaDowngradeTime property: The
     * nextAllowedQuotaDowngradeTime property.
     *
     * @param nextAllowedQuotaDowngradeTime the nextAllowedQuotaDowngradeTime
     * value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setNextAllowedQuotaDowngradeTime(OffsetDateTime nextAllowedQuotaDowngradeTime) {
        if (nextAllowedQuotaDowngradeTime == null) {
            this.nextAllowedQuotaDowngradeTime = null;
        } else {
            this.nextAllowedQuotaDowngradeTime = new DateTimeRfc1123(nextAllowedQuotaDowngradeTime);
        }
        return this;
    }

    /**
     * Get the deletedTime property: The deletedTime property.
     *
     * @return the deletedTime value.
     */
    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    /**
     * Set the deletedTime property: The deletedTime property.
     *
     * @param deletedTime the deletedTime value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setDeletedTime(OffsetDateTime deletedTime) {
        if (deletedTime == null) {
            this.deletedTime = null;
        } else {
            this.deletedTime = new DateTimeRfc1123(deletedTime);
        }
        return this;
    }

    /**
     * Get the remainingRetentionDays property: The remainingRetentionDays
     * property.
     *
     * @return the remainingRetentionDays value.
     */
    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    /**
     * Set the remainingRetentionDays property: The remainingRetentionDays
     * property.
     *
     * @param remainingRetentionDays the remainingRetentionDays value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    /**
     * Get the accessTier property: The accessTier property.
     *
     * @return the accessTier value.
     */
    public String getAccessTier() {
        return this.accessTier;
    }

    /**
     * Set the accessTier property: The accessTier property.
     *
     * @param accessTier the accessTier value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setAccessTier(String accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    /**
     * Get the accessTierChangeTime property: The accessTierChangeTime
     * property.
     *
     * @return the accessTierChangeTime value.
     */
    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    /**
     * Set the accessTierChangeTime property: The accessTierChangeTime
     * property.
     *
     * @param accessTierChangeTime the accessTierChangeTime value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        if (accessTierChangeTime == null) {
            this.accessTierChangeTime = null;
        } else {
            this.accessTierChangeTime = new DateTimeRfc1123(accessTierChangeTime);
        }
        return this;
    }

    /**
     * Get the accessTierTransitionState property: The
     * accessTierTransitionState property.
     *
     * @return the accessTierTransitionState value.
     */
    public String getAccessTierTransitionState() {
        return this.accessTierTransitionState;
    }

    /**
     * Set the accessTierTransitionState property: The
     * accessTierTransitionState property.
     *
     * @param accessTierTransitionState the accessTierTransitionState value to
     * set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setAccessTierTransitionState(String accessTierTransitionState) {
        this.accessTierTransitionState = accessTierTransitionState;
        return this;
    }

    /**
     * Get the leaseStatus property: Possible values include: 'locked',
     * 'unlocked'.
     *
     * @return the leaseStatus value.
     */
    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    /**
     * Set the leaseStatus property: Possible values include: 'locked',
     * 'unlocked'.
     *
     * @param leaseStatus the leaseStatus value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    /**
     * Get the leaseState property: Possible values include: 'available',
     * 'leased', 'expired', 'breaking', 'broken'.
     *
     * @return the leaseState value.
     */
    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    /**
     * Set the leaseState property: Possible values include: 'available',
     * 'leased', 'expired', 'breaking', 'broken'.
     *
     * @param leaseState the leaseState value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    /**
     * Get the leaseDuration property: Possible values include: 'infinite',
     * 'fixed'.
     *
     * @return the leaseDuration value.
     */
    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    /**
     * Set the leaseDuration property: Possible values include: 'infinite',
     * 'fixed'.
     *
     * @param leaseDuration the leaseDuration value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    /**
     * Get the enabledProtocols property: The enabledProtocols property.
     *
     * @return the enabledProtocols value.
     */
    public ShareProtocols getProtocols() {
        return this.protocols;
    }

    /**
     * Set the enabledProtocols property: The enabledProtocols property.
     *
     * @param protocols the enabledProtocols value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setProtocols(ShareProtocols protocols) {
        this.protocols = protocols;
        return this;
    }

    /**
     * Get the rootSquash property: Possible values include: 'NoRootSquash',
     * 'RootSquash', 'AllSquash'.
     *
     * @return the rootSquash value.
     */
    public ShareRootSquash getRootSquash() {
        return this.rootSquash;
    }

    /**
     * Set the rootSquash property: Possible values include: 'NoRootSquash',
     * 'RootSquash', 'AllSquash'.
     *
     * @param rootSquash the rootSquash value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setRootSquash(ShareRootSquash rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    /**
     * Get the metadata property: The metadata property.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The metadata property.
     *
     * @param metadata the metadata value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the enableSnapshotVirtualDirectoryAccess property:
     * Optional. Supported in version 2023-08-03 and above. Only applicable for premium file storage accounts.
     * Specifies whether the snapshot virtual directory should be accessible at the root of share mount point when NFS is enabled.
     * If not specified, the default is true.
     *
     * @return the enableSnapshotVirtualDirectoryAccess value.
     */
    public Boolean isSnapshotVirtualDirectoryAccessEnabled() {
        return this.enableSnapshotVirtualDirectoryAccess;
    }

    /**
     * Set the enableSnapshotVirtualDirectoryAccess property:
     * Optional. Supported in version 2023-08-03 and above. Only applicable for premium file storage accounts.
     * Specifies whether the snapshot virtual directory should be accessible at the root of share mount point when NFS is enabled.
     * If not specified, the default is true.
     *
     * @param enableSnapshotVirtualDirectoryAccess the enableSnapshotVirtualDirectoryAccess value to set.
     * @return the ShareProperties object itself.
     */
    public ShareProperties setSnapshotVirtualDirectoryAccessEnabled(
        Boolean enableSnapshotVirtualDirectoryAccess) {
        this.enableSnapshotVirtualDirectoryAccess = enableSnapshotVirtualDirectoryAccess;
        return this;
    }

    /**
     * Get the enablePaidBursting property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * This property enables paid bursting on premium file storage accounts.
     * @return the enablePaidBursting value.
     */
    public Boolean isPaidBurstingEnabled() {
        return enablePaidBursting;
    }

    /**
     * Set the enablePaidBursting property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * This property enables paid bursting on premium file storage accounts.
     * @param enablePaidBursting the enablePaidBursting value to set.
     * @return the ShareSetPropertiesOptions object itself.
     */
    public ShareProperties setPaidBurstingEnabled(Boolean enablePaidBursting) {
        this.enablePaidBursting = enablePaidBursting;
        return this;
    }

    /**
     * Get the paidBurstingMaxIops property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * Default if not specified is the maximum IOPS the file share can support.
     * Current maximum for a file share is 102,400 IOPS.
     * @return the paidBurstingMaxIops value.
     */
    public Long getPaidBurstingMaxIops() {
        return paidBurstingMaxIops;
    }

    /**
     * Set the paidBurstingMaxIops property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * Default if not specified is the maximum IOPS the file share can support.
     * Current maximum for a file share is 102,400 IOPS.
     * @param paidBurstingMaxIops the paidBurstingMaxIops value to set.
     * @return the ShareSetPropertiesOptions object itself.
     */
    public ShareProperties setPaidBurstingMaxIops(Long paidBurstingMaxIops) {
        this.paidBurstingMaxIops = paidBurstingMaxIops;
        return this;
    }

    /**
     * Get the paidBurstingMaxBandwidthMibps property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * Default if not specified is the maximum throughput the file share can support.
     * Current maximum for a file share is 10,340 MiB/sec.
     * @return the paidBurstingMaxBandwidthMibps value.
     */
    public Long getPaidBurstingMaxBandwidthMibps() {
        return paidBurstingMaxBandwidthMibps;
    }

    /**
     * Set the paidBurstingMaxBandwidthMibps property:
     * Optional. Supported in version 2023-11-03 and above. Only applicable for premium file storage accounts.
     * Default if not specified is the maximum throughput the file share can support.
     * Current maximum for a file share is 10,340 MiB/sec.
     * @param paidBurstingMaxBandwidthMibps the paidBurstingMaxBandwidthMibps value to set.
     * @return the ShareSetPropertiesOptions object itself.
     */
    public ShareProperties setPaidBurstingMaxBandwidthMibps(Long paidBurstingMaxBandwidthMibps) {
        this.paidBurstingMaxBandwidthMibps = paidBurstingMaxBandwidthMibps;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ShareProperties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);

        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.eTag);
        xmlWriter.writeIntElement("Quota", this.quota);
        xmlWriter.writeNumberElement("ProvisionedIops", this.provisionedIops);
        xmlWriter.writeNumberElement("ProvisionedIngressMBps", this.provisionedIngressMBps);
        xmlWriter.writeNumberElement("ProvisionedEgressMBps", this.provisionedEgressMBps);
        xmlWriter.writeStringElement("NextAllowedQuotaDowngradeTime",
            Objects.toString(this.nextAllowedQuotaDowngradeTime, null));
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeStringElement("AccessTier", this.accessTier);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeStringElement("AccessTierTransitionState", this.accessTierTransitionState);
        xmlWriter.writeStringElement("LeaseStatus", this.leaseStatus == null ? null : this.leaseStatus.toString());
        xmlWriter.writeStringElement("LeaseState", this.leaseState == null ? null : this.leaseState.toString());
        xmlWriter.writeStringElement("LeaseDuration",
            this.leaseDuration == null ? null : this.leaseDuration.toString());
        xmlWriter.writeStringElement("EnabledProtocols", Objects.toString(this.protocols, null));
        xmlWriter.writeStringElement("RootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }

        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareProperties if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the ShareProperties.
     */
    public static ShareProperties fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareProperties from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareProperties if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the ShareProperties.
     */
    public static ShareProperties fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "ShareProperties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareProperties deserializedShareProperties = new ShareProperties();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.eTag = reader.getStringElement();
                } else if ("Quota".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.quota = reader.getIntElement();
                } else if ("ProvisionedIops".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedIops = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedIngressMBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedIngressMBps = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedEgressMBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedEgressMBps = reader.getNullableElement(Integer::parseInt);
                } else if ("ProvisionedBandwidthMiBps".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.provisionedBandwidthMiBps
                        = reader.getNullableElement(Integer::parseInt);
                } else if ("NextAllowedQuotaDowngradeTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.nextAllowedQuotaDowngradeTime
                        = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.remainingRetentionDays = reader.getNullableElement(Integer::parseInt);
                } else if ("AccessTier".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTier = reader.getStringElement();
                } else if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTierChangeTime = reader.getNullableElement(DateTimeRfc1123::new);
                } else if ("AccessTierTransitionState".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.accessTierTransitionState = reader.getStringElement();
                } else if ("LeaseStatus".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseStatus = LeaseStatusType.fromString(reader.getStringElement());
                } else if ("LeaseState".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseState = LeaseStateType.fromString(reader.getStringElement());
                } else if ("LeaseDuration".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.leaseDuration = LeaseDurationType.fromString(reader.getStringElement());
                } else if ("EnabledProtocols".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.protocols = ModelHelper.parseShareProtocols(reader.getStringElement());
                } else if ("RootSquash".equals(elementName.getLocalPart())) {
                    deserializedShareProperties.rootSquash = ShareRootSquash.fromString(reader.getStringElement());
                } else if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedShareProperties.metadata == null) {
                            deserializedShareProperties.metadata = new LinkedHashMap<>();
                        }
                        deserializedShareProperties.metadata.put(reader.getElementName().getLocalPart(),
                            reader.getStringElement());
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareProperties;
        });
    }
}
