// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.file.share.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Settings for SMB protocol.
 */
@Fluent
public final class ShareSmbSettings implements XmlSerializable<ShareSmbSettings> {
    /*
     * Settings for SMB Multichannel.
     */
    private SmbMultichannel multichannel;

    /**
     * Creates an instance of ShareSmbSettings class.
     */
    public ShareSmbSettings() {
    }

    /**
     * Get the multichannel property: Settings for SMB Multichannel.
     * 
     * @return the multichannel value.
     */
    public SmbMultichannel getMultichannel() {
        return this.multichannel;
    }

    /**
     * Set the multichannel property: Settings for SMB Multichannel.
     * 
     * @param multichannel the multichannel value to set.
     * @return the ShareSmbSettings object itself.
     */
    public ShareSmbSettings setMultichannel(SmbMultichannel multichannel) {
        this.multichannel = multichannel;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SMB" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.multichannel, "Multichannel");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of ShareSmbSettings from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of ShareSmbSettings if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareSmbSettings.
     */
    public static ShareSmbSettings fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of ShareSmbSettings from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of ShareSmbSettings if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the ShareSmbSettings.
     */
    public static ShareSmbSettings fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SMB" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareSmbSettings deserializedShareSmbSettings = new ShareSmbSettings();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Multichannel".equals(elementName.getLocalPart())) {
                    deserializedShareSmbSettings.multichannel = SmbMultichannel.fromXml(reader, "Multichannel");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedShareSmbSettings;
        });
    }
}
