/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.FilesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.FilesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesAcquireLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesChangeLeaseHeaders;
import com.azure.storage.file.share.implementation.models.SharesRenewLeaseHeaders;
import com.azure.storage.file.share.models.ShareTokenIntent;
import com.azure.storage.file.share.options.ShareAcquireLeaseOptions;
import com.azure.storage.file.share.options.ShareBreakLeaseOptions;
import com.azure.storage.file.share.specialized.ShareLeaseClientBuilder;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareLeaseClientBuilder.class, isAsync=true)
public final class ShareLeaseAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareLeaseAsyncClient.class);
    private final String shareName;
    private final String shareSnapshot;
    private final String resourcePath;
    private final boolean isShareFile;
    private final AzureFileStorageImpl client;
    private final String accountName;
    private volatile String leaseId;

    ShareLeaseAsyncClient(HttpPipeline pipeline, String url, String shareName, String shareSnapshot, String resourcePath, String leaseId, boolean isShareFile, String accountName, String serviceVersion, boolean allowTrailingDot, boolean allowSourceTrailingDot, ShareTokenIntent shareTokenIntent) {
        this.isShareFile = isShareFile;
        this.leaseId = leaseId;
        this.client = new AzureFileStorageImpl(pipeline, serviceVersion, shareTokenIntent, url, allowTrailingDot, allowSourceTrailingDot);
        this.accountName = accountName;
        this.shareName = shareName;
        this.shareSnapshot = shareSnapshot;
        this.resourcePath = resourcePath;
    }

    @Deprecated
    public String getFileUrl() {
        return this.getResourceUrl();
    }

    public String getResourceUrl() {
        StringBuilder resourceUrlString = new StringBuilder(this.client.getUrl()).append("/").append(this.shareName);
        if (this.isShareFile) {
            resourceUrlString.append("/").append(this.resourcePath);
        }
        if (this.shareSnapshot != null) {
            resourceUrlString.append("?sharesnapshot=").append(this.shareSnapshot);
        }
        return resourceUrlString.toString();
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> acquireLease() {
        return this.acquireLeaseWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> acquireLeaseWithResponse() {
        return this.acquireLeaseWithResponse(new ShareAcquireLeaseOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> acquireLeaseWithResponse(ShareAcquireLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(ShareAcquireLeaseOptions options, Context context) {
        options = options == null ? new ShareAcquireLeaseOptions() : options;
        context = context == null ? Context.NONE : context;
        Mono response = this.isShareFile ? this.client.getFiles().acquireLeaseWithResponseAsync(this.shareName, this.resourcePath, null, options.getDuration(), this.leaseId, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((FilesAcquireLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId())) : this.client.getShares().acquireLeaseWithResponseAsync(this.shareName, null, options.getDuration(), this.leaseId, this.shareSnapshot, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((SharesAcquireLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLease() {
        return this.releaseLeaseWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::releaseLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            return this.client.getFiles().releaseLeaseNoCustomHeadersWithResponseAsync(this.shareName, this.resourcePath, this.leaseId, null, null, context);
        }
        return this.client.getShares().releaseLeaseNoCustomHeadersWithResponseAsync(this.shareName, this.leaseId, null, this.shareSnapshot, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> breakLease() {
        return this.breakLeaseWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseWithResponse() {
        return this.breakLeaseWithResponse(new ShareBreakLeaseOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> breakLeaseWithResponse(ShareBreakLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> breakLeaseWithResponse(ShareBreakLeaseOptions options, Context context) {
        Integer breakPeriod;
        options = options == null ? new ShareBreakLeaseOptions() : options;
        context = context == null ? Context.NONE : context;
        Integer n = breakPeriod = options.getBreakPeriod() == null ? null : Integer.valueOf(Math.toIntExact(options.getBreakPeriod().getSeconds()));
        if (this.isShareFile) {
            return this.client.getFiles().breakLeaseNoCustomHeadersWithResponseAsync(this.shareName, this.resourcePath, null, null, null, context);
        }
        return this.client.getShares().breakLeaseNoCustomHeadersWithResponseAsync(this.shareName, null, breakPeriod, null, null, this.shareSnapshot, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> changeLeaseWithResponse(String proposedId) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(proposedId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(String proposedId, Context context) {
        context = context == null ? Context.NONE : context;
        Mono response = this.isShareFile ? this.client.getFiles().changeLeaseWithResponseAsync(this.shareName, this.resourcePath, this.leaseId, null, proposedId, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((FilesChangeLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId())) : this.client.getShares().changeLeaseWithResponseAsync(this.shareName, this.leaseId, null, proposedId, this.shareSnapshot, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((SharesChangeLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> renewLease() {
        return this.renewLeaseWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> renewLeaseWithResponse() {
        try {
            return FluxUtil.withContext(this::renewLeaseWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> renewLeaseWithResponse(Context context) {
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isShareFile) {
            throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot renew a lease on a share file."));
        }
        Mono response = this.client.getShares().renewLeaseWithResponseAsync(this.shareName, this.leaseId, null, this.shareSnapshot, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((SharesRenewLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    public String getAccountName() {
        return this.accountName;
    }
}

